#include "kdoublefb.h"
#include "ui_kdoublefb.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>

KdoubleFB::KdoubleFB(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::KdoubleFB)
{
    ui->setupUi(this);

    //Set Window
    this->setWindowTitle(tr("Double Fisherman's Bend"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    //Set Image
    imgScene = new QGraphicsScene(ui->img);
    QGraphicsPixmapItem *item;
    QPixmap mImg("/opt/qnotted/images/kdoublefb.jpg");
    ui->img->setScene(imgScene);
    mImg = mImg.scaled(QSize(180, 180), Qt::KeepAspectRatio);
    item = new QGraphicsPixmapItem(mImg);
    imgScene->addItem(item);

    //Set Large Image
    imgSceneLarge = new QGraphicsScene(ui->imgLarge);
    QGraphicsPixmapItem *itemLarge;
    QPixmap mImgLarge("/opt/qnotted/images/kdoublefb.jpg");
    ui->imgLarge->setScene(imgSceneLarge);
    mImgLarge = mImgLarge.scaled(QSize(440, 440), Qt::KeepAspectRatio);
    itemLarge = new QGraphicsPixmapItem(mImgLarge);
    imgSceneLarge->addItem(itemLarge);

    //Button Text
    ui->pushButton_Up->setText("");
    ui->pushButton_Down->setText("");
    ui->pushButton_Reset->setText("");


    // Set Button Icons
    ui->pushButton_Up->setIcon(QPixmap("/opt/qnotted/icons/br_up_icon&48.png"));
    ui->pushButton_Down->setIcon(QPixmap("/opt/qnotted/icons/br_down_icon&48.png"));
    ui->pushButton_Reset->setIcon(QPixmap("/opt/qnotted/icons/dash.png"));

    //Hide On Draw
    ui->pushButton_Reset->hide();
    ui->imgLarge->hide();

    //Set Text
    ui->textBrowser->setText(tr("\
        <b><u>Double Fisherman's Bend</u></b> <br> \
        Tie a loose Double Overhand Stopper Knot near the end of one of the ropes. <br> \
        Pass the end of the second rope through the middle of the Double Overhand knot. <br> \
        In the second rope tie another Double Overhand Knot around the standing end of the first rope. <br> \
        Dress both Double Overhand knots. <br> \
        Pull on both standing ends to tighten the Double Overhand Knots against each other. <br> \
        <b><u>Triple Fisherman's Bend</u></b> <br> \
        Follow the same procedure above replacing the Double Overhand Knots with Triple Overhand Knots. <br> \
                                "));

    // For Connecting Keyboard Buttons
              connectSignals();
}

KdoubleFB::~KdoubleFB()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void KdoubleFB::connectSignals()
{

// Keyboard Key Signals

        connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
     connect(new QShortcut(QKeySequence(Qt::Key_Up), this), SIGNAL(activated()), this, SLOT(on_pushButton_Up_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Down), this), SIGNAL(activated()), this, SLOT(on_pushButton_Down_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Space), this), SIGNAL(activated()), this, SLOT(on_pushButton_Reset_pressed()));
}

// End of Keyboard Signals


//Push Buttons

void KdoubleFB::on_pushButton_Up_pressed()
{
    ui->img->hide();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->hide();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->show();
}

void KdoubleFB::on_pushButton_Reset_pressed()
{
    ui->img->show();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->show();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->hide();
}

void KdoubleFB::on_pushButton_Down_pressed()
{
    ui->img->hide();
    ui->imgLarge->show();
    ui->textBrowser->hide();
    ui->pushButton_Up->show();
    ui->pushButton_Down->hide();
    ui->pushButton_Reset->show();
}
