#include "koyster.h"
#include "ui_koyster.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>

Koyster::Koyster(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Koyster)
{
    ui->setupUi(this);

    //Set Window
    this->setWindowTitle(tr("Oysterman's Stopper"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    //Set Image
    imgScene = new QGraphicsScene(ui->img);
    QGraphicsPixmapItem *item;
    QPixmap mImg("/opt/qnotted/images/koyster.jpg");
    ui->img->setScene(imgScene);
    mImg = mImg.scaled(QSize(180, 180), Qt::KeepAspectRatio);
    item = new QGraphicsPixmapItem(mImg);
    imgScene->addItem(item);

    //Set Large Image
    imgSceneLarge = new QGraphicsScene(ui->imgLarge);
    QGraphicsPixmapItem *itemLarge;
    QPixmap mImgLarge("/opt/qnotted/images/koyster.jpg");
    ui->imgLarge->setScene(imgSceneLarge);
    mImgLarge = mImgLarge.scaled(QSize(440, 440), Qt::KeepAspectRatio);
    itemLarge = new QGraphicsPixmapItem(mImgLarge);
    imgSceneLarge->addItem(itemLarge);

    //Button Text
    ui->pushButton_Up->setText("");
    ui->pushButton_Down->setText("");
    ui->pushButton_Reset->setText("");


    // Set Button Icons
    ui->pushButton_Up->setIcon(QPixmap("/opt/qnotted/icons/br_up_icon&48.png"));
    ui->pushButton_Down->setIcon(QPixmap("/opt/qnotted/icons/br_down_icon&48.png"));
    ui->pushButton_Reset->setIcon(QPixmap("/opt/qnotted/icons/dash.png"));

    //Hide On Draw
    ui->pushButton_Reset->hide();
    ui->imgLarge->hide();


    //Set Text
    ui->textBrowser->setText(tr("\
        <b><u>Oysterman's Stopper</u></b> <br> \
        Make an initial bight in the end of the rope, with the tail end laying next to the standing end. <br> \
        Fold the bight over onto the standing end and tail forming two opposing loops. <br> \
        Pass the loop in the standing end up through the other loop and pull tight to form a Noose. <br> \
        Pass the tail infront of the standing end and through the Noose from behind. <br> \
        Finally pull the standing end to close the Noose. <br> \
        Dress the knot so the underside of the knot shows three separate lobes. <br> \
                                "));

    // For Connecting Keyboard Buttons
              connectSignals();
}

Koyster::~Koyster()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Koyster::connectSignals()
{

// Keyboard Key Signals

        connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
     connect(new QShortcut(QKeySequence(Qt::Key_Up), this), SIGNAL(activated()), this, SLOT(on_pushButton_Up_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Down), this), SIGNAL(activated()), this, SLOT(on_pushButton_Down_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Space), this), SIGNAL(activated()), this, SLOT(on_pushButton_Reset_pressed()));
}

// End of Keyboard Signals


//Push Buttons

void Koyster::on_pushButton_Up_pressed()
{
    ui->img->hide();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->hide();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->show();
}

void Koyster::on_pushButton_Reset_pressed()
{
    ui->img->show();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->show();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->hide();
}

void Koyster::on_pushButton_Down_pressed()
{
    ui->img->hide();
    ui->imgLarge->show();
    ui->textBrowser->hide();
    ui->pushButton_Up->show();
    ui->pushButton_Down->hide();
    ui->pushButton_Reset->show();
}
