#include "wmid.h"
#include "ui_wmid.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>

Wmid::Wmid(QWidget *parent):
    QDialog(parent),
       ui(new Ui::Wmid)


{
    ui->setupUi(this);

    this->setWindowTitle(tr("Mid Loops"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    ui->pushButtonKalpineLoop->setText(tr("Alpine Butterfly Loop"));
    ui->pushButtonKbunny->setText(tr("Figure 8 Double Loop"));
    ui->pushButtonKfig9->setText(tr("Figure 9 Loop"));
    ui->pushButtonKhandcuff->setText(tr("Handcuff Knot"));

    // For Connecting Keyboard Buttons
      connectSignals();

}

Wmid::~Wmid()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Wmid::connectSignals()
{

// Keyboard Key Signals

   connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
  connect(new QShortcut(QKeySequence(Qt::Key_Q), this), SIGNAL(activated()), this, SLOT(on_pushButtonKalpineLoop_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_W), this), SIGNAL(activated()), this, SLOT(on_pushButtonKbunny_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_E), this), SIGNAL(activated()), this, SLOT(on_pushButtonKfig9_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_R), this), SIGNAL(activated()), this, SLOT(on_pushButtonKhandcuff_pressed()));
}

// End of Keyboard Signals

//Buttons

void Wmid::on_pushButtonKalpineLoop_pressed()
{
    KalpineLoop *kalpineLoop = new KalpineLoop(this);
    kalpineLoop->show();
}

void Wmid::on_pushButtonKbunny_pressed()
{
    Kbunny *kbunny = new Kbunny(this);
    kbunny->show();
}

void Wmid::on_pushButtonKfig9_pressed()
{
    Kfig9 *kfig9 = new Kfig9(this);
    kfig9->show();
}

void Wmid::on_pushButtonKhandcuff_pressed()
{
    Khandcuff *khandcuff = new Khandcuff(this);
    khandcuff->show();
}
