#include "kbowline.h"
#include "ui_kbowline.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>

Kbowline::Kbowline(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Kbowline)
{
    ui->setupUi(this);

    //Set Window
    this->setWindowTitle(tr("Bowline"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    //Set Small Image
    imgScene = new QGraphicsScene(ui->img);
    QGraphicsPixmapItem *item;
    QPixmap mImg("/opt/qnotted/images/kbowline.jpg");
    ui->img->setScene(imgScene);
    mImg = mImg.scaled(QSize(180, 180), Qt::KeepAspectRatio);
    item = new QGraphicsPixmapItem(mImg);
    imgScene->addItem(item);

    //Set Large Image
    imgSceneLarge = new QGraphicsScene(ui->imgLarge);
    QGraphicsPixmapItem *itemLarge;
    QPixmap mImgLarge("/opt/qnotted/images/kbowline.jpg");
    ui->imgLarge->setScene(imgSceneLarge);
    mImgLarge = mImgLarge.scaled(QSize(440, 440), Qt::KeepAspectRatio);
    itemLarge = new QGraphicsPixmapItem(mImgLarge);
    imgSceneLarge->addItem(itemLarge);

    //Button Text
    ui->pushButton_Up->setText("");
    ui->pushButton_Down->setText("");
    ui->pushButton_Reset->setText("");


    // Set Button Icons
    ui->pushButton_Up->setIcon(QPixmap("/opt/qnotted/icons/br_up_icon&48.png"));
    ui->pushButton_Down->setIcon(QPixmap("/opt/qnotted/icons/br_down_icon&48.png"));
    ui->pushButton_Reset->setIcon(QPixmap("/opt/qnotted/icons/dash.png"));

    //Hide On Draw
    ui->pushButton_Reset->hide();
    ui->imgLarge->hide();

    //Set Text
    ui->textBrowser->setText(tr("\
        <b><u>Bowline</u></b> <br> \
        Make a small right facing loop in the rope with the working part passing over the standing part. <br> \
        Leave enough rope to create the correct size of loop and stoppers, if required. <br> \
        Form the required sized loop in the rope, then pass the working end of the rope up through the small loop. <br> \
        Continue to pass this working end around the standing end and then back down through the small loop. <br> \
        <br> \
        <b><u>Stopped Bowline</u></b> <br> \
        If required the bowline can be stopped for extra security in a few ways. <br> \
        The <b>in loop stoppper</b> <i>(shown)</i> is tying a stopper knot in the tail end to the adjacent side of the loop. <br> \
        Alternatively the <b>line stopper</b> is tying a stopper knot in the tail end back to the standing end. <br> \
        A Double Overhand Stopper Knot is best for this purpose. <br> \
        <b>Important</b> <br> \
        One minor flaw in the Bowline is with no load on the knot, it can fall untied. <br> \
        For applications where this is possible a Water Bowline should be used. <br> \
                                "));

     // For Connecting Keyboard Buttons
              connectSignals();
}

Kbowline::~Kbowline()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Kbowline::connectSignals()
{

// Keyboard Key Signals

        connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
     connect(new QShortcut(QKeySequence(Qt::Key_Up), this), SIGNAL(activated()), this, SLOT(on_pushButton_Up_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Down), this), SIGNAL(activated()), this, SLOT(on_pushButton_Down_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Space), this), SIGNAL(activated()), this, SLOT(on_pushButton_Reset_pressed()));
}

// End of Keyboard Signals


//Push Buttons

void Kbowline::on_pushButton_Up_pressed()
{
    ui->img->hide();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->hide();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->show();
}

void Kbowline::on_pushButton_Reset_pressed()
{
    ui->img->show();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->show();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->hide();
}

void Kbowline::on_pushButton_Down_pressed()
{
    ui->img->hide();
    ui->imgLarge->show();
    ui->textBrowser->hide();
    ui->pushButton_Up->show();
    ui->pushButton_Down->hide();
    ui->pushButton_Reset->show();
}
