# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
from DialogRecordData import Ui_DialogRecordManager

from MyNotify import MyNotify

from QNMDBusClient import QNMDBusClient

QtCore.Signal = QtCore.pyqtSignal
QtCore.Slot = QtCore.pyqtSlot

from StatistData import pixmapIface_pic


class DialogRecordManagerExt(Ui_DialogRecordManager, QtCore.QObject):
	stateRecordChange = QtCore.Signal()
	def __init__(self, dlg, mydb, mydbus):
		QtCore.QObject.__init__(self)
		self.dlg = dlg
		self.setupUi(dlg)

		self.mydbus = mydbus
		self.noti = MyNotify()

		self.my_db = mydb
		self.listSupportIface = self.my_db.optGetSupportIface()

		self.action()

	
	def action(self):
		tp = 1
		for i in self.listSupportIface:
			item_pic = pixmapIface_pic( i['iface'] )
			item = QtGui.QListWidgetItem( QtGui.QIcon(item_pic), i['iface'] )
			self.lWIface.addItem( item )

		self.pbRecStartStop.setEnabled( False )
		#self.pbAutoRecOnOff.hide()
		
		self.lWIface.itemClicked.connect( self.clickedItem )
		self.pbRecStartStop.toggled.connect( self.recStartStop )

		self.prevState_recNow = {}
		
		QtCore.QObject.connect( QtGui.QApplication.desktop(), QtCore.SIGNAL("resized(int)"), self.orientationChanged )
		self.orientationChanged()


	# получает по шине DBus информацию о том, 
	# включена ли запись данных, в данный момент, на указанном сетевом интерфейсе iface
	def statusRecordNow( self, iface ):
		try:
			statusRec = self.mydbus.recStatus( iface )
			self.prevState_recNow[ iface ] = statusRec
			self.pbRecStartStop.setChecked( statusRec )
			
			#включаем кнопку
			self.pbRecStartStop.setEnabled( True )
		except Exception, e:
			self.pbRecStartStop.setEnabled( False )



	# слот, вызывается при клике на пункт списка сетевых интерфейсов
	def clickedItem( self , item ):
		self.pbRecStartStop.setEnabled( False )
		#отображем параметры сетевого интерфейса
		self.statisticIface( item.text() )
		#проверям статус записи в данный момент
		self.statusRecordNow( item.text() )



	def recStartStop( self, checked ):
		item = self.lWIface.selectedItems()[0]
		name_iface = item.text()
		
#TODO: Изменить код на ускорение реакции кнопки

		##Эта операция перенесена в демона
		##type_iface = self.my_db.getTypeByIface( name_iface )
		##self.my_db.autoRecEnable( type_iface, checked )

		if self.prevState_recNow[ name_iface ] != checked:
			if checked:
				start_ok = self.mydbus.recStart( name_iface )
				txt = QtGui.QApplication.translate("DialogRecordDataExt", "Attention! Data recording will continue to until it is stopped manually, or network interface will be deactivated.", None, QtGui.QApplication.UnicodeUTF8)
				self.noti.notify_m("%s"%txt)
			else:
				stop_ok = self.mydbus.recStop( name_iface )
				txt = QtGui.QApplication.translate("DialogRecordDataExt", "Data record is disabled", None, QtGui.QApplication.UnicodeUTF8)
				self.noti.notify( "%s"%txt )

			self.stateRecordChange.emit()
		
		self.prevState_recNow[ name_iface ] = checked


	def statisticIface(self, iface):
		p_stat = "/sys/class/net/"+iface+"/statistics/"
		p_dat = "/sys/class/net/"+iface+"/"
		rx_b = p_stat+"rx_bytes"
		rx_p = p_stat+"rx_packets"
		tx_b = p_stat+"tx_bytes"
		tx_p = p_stat+"tx_packets"
		mac_addr = p_dat+"address"
				
		txt_mac = QtGui.QApplication.translate("DialogRecordDataExt", "MAC address", None, QtGui.QApplication.UnicodeUTF8)
		rx_b_p = QtGui.QApplication.translate("DialogRecordDataExt", "RX bytes/RX packets", None, QtGui.QApplication.UnicodeUTF8)
		tx_b_p = QtGui.QApplication.translate("DialogRecordDataExt", "TX bytes/TX packets", None, QtGui.QApplication.UnicodeUTF8)
		network_iface_txt = QtGui.QApplication.translate("DialogRecordDataExt", "Network interface", None, QtGui.QApplication.UnicodeUTF8)

		mac = self.fileData( mac_addr )
		rxb = self.fileData( rx_b )
		rxp = self.fileData( rx_p )
		txb = self.fileData( tx_b )
		txp = self.fileData( tx_p )
		s  = "<html>"
		s += "<dl style='font-size: 12pt;'>"
		if mac != None:
			s += "<dt><b>%s:</b></dt> <dd>%s - <font color=green>ONLINE</font><></dd>"%(network_iface_txt, iface)
			s += "<dt><b>%s:</b></dt> <dd>%s</dd>"%(txt_mac,mac)
			s += "<dt><b>%s:</b></dt> <dd>%s / %s</dd>"%(rx_b_p, rxb, rxp)
			s += "<dt><b>%s:</b></dt> <dd>%s / %s</dd>"%(tx_b_p, txb, txp)
		else:
			s += "<dt><b>%s:</b></dt> <dd>%s - <font color=red>OFFLINE</font></dd>"%(network_iface_txt, iface)
		s += "</dl>"
		s += "</html>"
		self.tERecInfo.setHtml( s )
	

	def fileData(self, path_file):
		d = None
		qf = QtCore.QFile(path_file)
		if qf.open( QtCore.QIODevice.ReadOnly ):
			d = qf.readLine()
			qf.close()
		return d
	
	def orientationChanged( self ):
		screenGeometry = QtGui.QApplication.desktop().screenGeometry()
		
		self.gridLayout.removeWidget( self.tERecInfo )
		self.gridLayout.removeWidget( self.lWIface )
		self.gridLayout.removeWidget( self.pbRecStartStop )

		if screenGeometry.width() > screenGeometry.height():
			# landscape
			self.dlg.setMaximumSize(800, 360)
			self.dlg.setMinimumSize(800, 360)

			self.gridLayout.addWidget( self.tERecInfo, 0, 0, 2, 1 )
			self.gridLayout.addWidget( self.lWIface, 0, 1, 1, 1 )
			self.gridLayout.addWidget( self.pbRecStartStop, 1, 1, 1, 1 )
		else:
			#portait
			self.dlg.setMaximumSize(440, 650)
			self.dlg.setMinimumSize(440, 650)

			self.gridLayout.addWidget( self.tERecInfo, 0, 0, 1, 1 )
			self.gridLayout.addWidget( self.lWIface, 1, 0, 1, 1 )
			self.gridLayout.addWidget( self.pbRecStartStop, 2, 0, 1, 1 )
