#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
import WindowFilterOptions
import DateWindowExt
from gettraff import GetTraff
import myconfig
from StatistData import pixmapIface_str, checkOrientation

class WindowFilterOptionsExt( QtGui.QMainWindow ):
	def __init__(self, parent, parentUi, qset ):
		QtGui.QMainWindow.__init__(self, parent )

		self.parentUI = parentUi
		self.parent = parent
		self.qset = qset
				
		try:
			self.setAttribute( QtCore.Qt.WA_Maemo5StackedWindow )
			self.setAttribute( QtCore.Qt.WA_Maemo5ShowProgressIndicator )
		except Exception, e:
			pass
			#print "WindowFilterOptionsExt::__init__(): Exception setAttribute(): ", e

		self.ui = WindowFilterOptions.Ui_MainWindow()
		self.ui.setupUi( self )
		self.actionForm()

		#self.setWindowTitle( "Filter options" )


	def actionForm(self):
		self.ui.dTEStart.setDateTime( QtCore.QDateTime.currentDateTime() )
		self.ui.dTEEnd.setDateTime( QtCore.QDateTime.currentDateTime() )

		if self.ui.cBStart.checkState() == QtCore.Qt.Checked:
			self.ui.dTEStart.setEnabled( True )
			self.ui.pBCalStart.setEnabled( True )
		else:
			self.ui.dTEStart.setEnabled( False )
			self.ui.pBCalStart.setEnabled( False )
		
		if self.ui.cBEnd.checkState() == QtCore.Qt.Checked:
			self.ui.dTEEnd.setEnabled( True )
			self.ui.pBCalEnd.setEnabled( True )
		else:
			self.ui.dTEEnd.setEnabled( False )
			self.ui.pBCalEnd.setEnabled( False )

		self.ui.cBStart.stateChanged.connect( self.changeStartCB )
		self.ui.cBEnd.stateChanged.connect( self.changeEndCB )


		self.ui.pBCancel.clicked.connect( self.cancelFilter )
		self.ui.pBAccept.clicked.connect( self.acceptFilter )

		self.ui.pBCalStart.clicked.connect( self.winCalStartDate )
		self.ui.pBCalEnd.clicked.connect( self.winCalEndDate )

		self.ui.lWIface.clear()
		item = QtGui.QListWidgetItem( QtGui.QIcon(QtGui.QPixmap(":/pic48/pictures/unknown.png")), "All" )
		self.ui.lWIface.addItem( item )
		item.setData( QtCore.Qt.UserRole+1, 0 )
		listSupportIface = self.parent.db.optGetSupportIface()
		for i in listSupportIface:
			item_pic = pixmapIface_str( i['iface'] )
			item = QtGui.QListWidgetItem( QtGui.QIcon(QtGui.QPixmap(item_pic)), i['iface'] )
			item.setData( QtCore.Qt.UserRole+1, i['type'] )
			self.ui.lWIface.addItem( item )
		self.ui.lWIface.setCurrentRow(0)

		#предустановленные значения, исходя из сохраненных настроек фильтра
		sT = self.qset.filterGetStartTime()
		if sT != None:
			self.ui.dTEStart.setDateTime( QtCore.QDateTime.fromString( sT, "yyyy-MM-dd HH:mm:ss") )
		eT = self.qset.filterGetStopTime()
		if eT != None:
			self.ui.dTEEnd.setDateTime( QtCore.QDateTime.fromString( eT, "yyyy-MM-dd HH:mm:ss") )
		
		QtCore.QObject.connect( QtGui.QApplication.desktop(), QtCore.SIGNAL("resized(int)"), self.orientationChanged )
		self.orientationChanged()



	def changeStartCB(self, state ):
		if state:
			self.ui.dTEStart.setEnabled( True )
			self.ui.pBCalStart.setEnabled( True )
		else:
			self.ui.dTEStart.setEnabled( False )
			self.ui.pBCalStart.setEnabled( False )

	def changeEndCB(self, state ):
		if state:
			self.ui.dTEEnd.setEnabled( True )
			self.ui.pBCalEnd.setEnabled( True )
		else:
			self.ui.dTEEnd.setEnabled( False )
			self.ui.pBCalEnd.setEnabled( False )

	def acceptFilter(self):
		n = self.ui.lWIface.currentRow()
		item = self.ui.lWIface.item( n )
		item_num = item.data( QtCore.Qt.UserRole+1 )
		item_num = item_num.toInt()
		item_num = item_num[0]

		type_iface = 0
		if n != 0:
			type_iface = self.parent.db.getTypeByIface( "%s"%item.text() )

		self.parentUI.pBFilter.setChecked( True )
		self.hide()
		startDT = None
		endDT = None
		if (self.ui.cBStart.checkState() == QtCore.Qt.Checked) and (self.ui.cBEnd.checkState() == QtCore.Qt.Checked):
			startDT = self.ui.dTEStart.dateTime().toString("yyyy-MM-dd hh:mm:ss")
			endDT = self.ui.dTEEnd.dateTime().toString("yyyy-MM-dd hh:mm:ss")
			self.parent.initItemsSession(startDT, endDT, type_iface)
		elif (self.ui.cBStart.checkState() == QtCore.Qt.Checked) and (self.ui.cBEnd.checkState() == QtCore.Qt.Unchecked):
			startDT = self.ui.dTEStart.dateTime().toString("yyyy-MM-dd hh:mm:ss")
			self.parent.initItemsSession(startDT, None, type_iface)
		elif (self.ui.cBStart.checkState() == QtCore.Qt.Unchecked) and (self.ui.cBEnd.checkState() == QtCore.Qt.Checked):
			endDT = self.ui.dTEEnd.dateTime().toString("yyyy-MM-dd hh:mm:ss")
			self.parent.initItemsSession(None, endDT, type_iface)
		else:
			self.parent.initItemsSession(None, None, type_iface)

		#вкл. фильтра в настройках
		self.qset.filterSetStatus(1)

		if startDT != None:
			self.qset.filterSetStartTime( startDT )
		else:
			self.qset.filterRemStartTime()

		if endDT != None:
			self.qset.filterSetStopTime( endDT )
		else:
			self.qset.filterRemStopTime()

		self.qset.filterSetIfaceType( type_iface )

	def cancelFilter(self):
		self.parentUI.pBFilter.setChecked( False )
		#откл. фильтра в настройках
		self.qset.filterSetStatus(0)
		self.hide()


	def winCalStartDate(self):
		self.wDate = DateWindowExt.DateWindowExt( self, self.ui.dTEStart )
		self.wDate.show()
	
	def winCalEndDate(self):
		self.wDate = DateWindowExt.DateWindowExt( self, self.ui.dTEEnd )
		self.wDate.show()
	
	
	def orientationChanged( self ):
			
		self.ui.gridLayout.removeWidget( self.ui.cBStart )
		self.ui.gridLayout.removeWidget( self.ui.cBEnd )
		self.ui.gridLayout.removeWidget( self.ui.dTEStart )
		self.ui.gridLayout.removeWidget( self.ui.dTEEnd )
		self.ui.gridLayout.removeWidget( self.ui.pBCalStart )
		self.ui.gridLayout.removeWidget( self.ui.pBCalEnd )
		self.ui.gridLayout.removeWidget( self.ui.lWIface )
		#self.ui.gridLayout.removeWidget( self.ui.pBAccept )
		#self.ui.gridLayout.removeWidget( self.ui.pBCancel )
		self.ui.gridLayout.removeItem( self.ui.horizontalLayout )

		o = checkOrientation()
		if o == "L":
			# landscape
			self.ui.gridLayout.addWidget( self.ui.lWIface, 0, 2, 4, 1 )

			self.ui.pBCalStart.setMinimumSize(QtCore.QSize(100,90))

			self.ui.gridLayout.addWidget( self.ui.cBStart, 0, 0, 1, 2 )
			self.ui.gridLayout.addWidget( self.ui.dTEStart, 1, 0 )
			self.ui.gridLayout.addWidget( self.ui.pBCalStart, 1, 1 )

			self.ui.gridLayout.addWidget( self.ui.cBEnd, 2, 0, 1, 2 )
			self.ui.gridLayout.addWidget( self.ui.dTEEnd, 3, 0 )
			self.ui.gridLayout.addWidget( self.ui.pBCalEnd, 3, 1 )

			#self.ui.gridLayout.addWidget( self.ui.pBCancel, 4, 0  )
			#self.ui.gridLayout.addWidget( self.ui.pBAccept, 4, 1, 1, 2  )
			self.ui.gridLayout.addItem( self.ui.horizontalLayout, 4, 0, 1, 4 )
		else:
			#portait
			self.ui.gridLayout.addWidget( self.ui.lWIface, 0, 0, 1, 4 )

			self.ui.gridLayout.addWidget( self.ui.cBStart, 1, 0, 1, 4 )
			self.ui.gridLayout.addWidget( self.ui.dTEStart, 2, 0, 1, 3 )
			self.ui.gridLayout.addWidget( self.ui.pBCalStart, 2, 3 )

			self.ui.gridLayout.addWidget( self.ui.cBEnd, 3, 0, 1, 4 )
			self.ui.gridLayout.addWidget( self.ui.dTEEnd, 4, 0, 1, 3 )
			self.ui.gridLayout.addWidget( self.ui.pBCalEnd, 4, 3 )
			
			#self.ui.gridLayout.addWidget( self.ui.pBCancel, 5, 0, 1, 4  )
			#self.ui.gridLayout.addWidget( self.ui.pBAccept, 6, 0, 1, 4  )
			self.ui.gridLayout.addItem( self.ui.horizontalLayout, 5, 0, 1, 4 )
