#!/usr/bin/env python
# -*- coding: utf-8 -*-

from os import geteuid, seteuid, listdir, readlink
from re import compile, search
import string
import socket

class NetStat:
	file_tcp = "/proc/net/tcp"
	file_udp = "/proc/net/udp"

	tcp_state = ["","ESTABLISHED","SYN_SENT","SYN_RECV","FIN_WAIT1","FIN_WAIT2","TIME_WAIT","CLOSE","CLOSE_WAIT","LAST_ACK","LISTEN","CLOSING"]

	def __init__(self):
		self.pat = compile(r'(socket:\[(\d)*\])')


	def uidDown(self):
		try:
			myuid = geteuid()
			if myuid == 0:
				seteuid(29999)
		except:
			pass
		print "NetStat::uidDown(): whoami: %s"%geteuid()


	def uidUp(self):
		try:
			seteuid(0)
		except:
			pass
		print "NetStat::uidUp(): whoami: %s"%geteuid()


	def convert_ipaddr(self, str_ip_addr):
		res = ""
		try:
			byte1 = int('0x%s'%str_ip_addr[6:8], 16)
			byte2 = int('0x%s'%str_ip_addr[4:6], 16)
			byte3 = int('0x%s'%str_ip_addr[2:4], 16)
			byte4 = int('0x%s'%str_ip_addr[0:2], 16)
			res = "%s.%s.%s.%s"%(byte1, byte2, byte3, byte4)
		except Exception:
			pass
		return res


	def getStatTCP(self, resolve = False):
		retList = list()
		
		f = open(self.file_tcp,"r")
		lines_file = f.readlines()
		f.close()

		for line in lines_file:
			try:
				bufConnection = {}
				elements_line = string.split(line)
				local_addr_l  =  string.split(elements_line[1],':')
				foreign_addr_l = string.split(elements_line[2],':')
				if resolve:
					bufConnection['local_addr'] = socket.getfqdn( self.convert_ipaddr( local_addr_l[0] ) )
					bufConnection['foreign_addr'] = socket.getfqdn( self.convert_ipaddr( foreign_addr_l[0] ) )
					try:
						lport = int("%s"%local_addr_l[1],16)
						bufConnection['local_port'] = socket.getservbyport( lport, 'tcp')
					except Exception:
						bufConnection['local_port'] = int( '0x%s'%local_addr_l[1], 16 )
					try:
						fport = int("%s"%foreign_addr_l[1],16)
						bufConnection['foreign_port'] = socket.getservbyport( fport, 'tcp')
					except Exception:
						bufConnection['foreign_port'] = int( '0x%s'%foreign_addr_l[1] ,16 )
				else:
					bufConnection['local_port'] = int( '0x%s'%local_addr_l[1], 16 )
					bufConnection['local_addr'] = self.convert_ipaddr( local_addr_l[0] )
					bufConnection['foreign_addr'] = self.convert_ipaddr( foreign_addr_l[0] )
					bufConnection['foreign_port'] = int( '0x%s'%foreign_addr_l[1] ,16 )
				stat = int('0x%s'%elements_line[3], 16)
				bufConnection['state'] = self.tcp_state[ stat ]
				bufConnection['inode'] = elements_line[9]
				#get pid
				pid = self.getPidByInode( int(elements_line[9],10) )
				if pid != None:
					cmdline = self.getInfoProcByPid( pid )
					bufConnection['pid'] = pid
					bufConnection['cmd'] = cmdline
				else:
					bufConnection['pid'] = ''
					bufConnection['cmd'] = ''

				retList.append( bufConnection )
				#print bufConnection['local_addr'], bufConnection['local_port'], bufConnection['foreign_addr'], bufConnection['foreign_port'], bufConnection['state'], bufConnection['inode']
			except Exception:
				pass
		return retList


	def getStatUDP(self, resolve = False):
		retList = list()
		f = open(self.file_udp,"r")
		lines_file = f.readlines()
		f.close()
		for line in lines_file:
			try:
				bufConnection = {}
				elements_line = string.split(line)
				local_addr_l  =  string.split(elements_line[1],':')
				foreign_addr_l = string.split(elements_line[2],':')
				if resolve:
					bufConnection['local_addr'] = socket.getfqdn( self.convert_ipaddr( local_addr_l[0] ) )
					bufConnection['foreign_addr'] = socket.getfqdn( self.convert_ipaddr( foreign_addr_l[0] ) )

					try:
						lport = int("%s"%local_addr_l[1],16)
						bufConnection['local_port'] = socket.getservbyport( lport , 'udp')
					except Exception:
						bufConnection['local_port'] = int( '0x%s'%local_addr_l[1], 16 )

					try:
						fport = int("%s"%foreign_addr_l[1],16)
						bufConnection['foreign_port'] = socket.getservbyport( fport, 'udp')
					except Exception:
						bufConnection['foreign_port'] = int( '0x%s'%foreign_addr_l[1] ,16 )
				else:
					bufConnection['local_port'] = int( '0x%s'%local_addr_l[1], 16 )
					bufConnection['local_addr'] = self.convert_ipaddr( local_addr_l[0] )
					bufConnection['foreign_addr'] = self.convert_ipaddr( foreign_addr_l[0] )
					bufConnection['foreign_port'] = int( '0x%s'%foreign_addr_l[1] ,16 )

				stat = elements_line[3]
				if stat == '01':
					bufConnection['state'] = 'ESTABLISHED'
				elif stat == '07':
					bufConnection['state'] = ''
				else:
					bufConnection['state'] = 'UNKNOWN'
				bufConnection['inode'] = elements_line[9]
				#get pid
				pid = self.getPidByInode( int(elements_line[9],10) )
				if pid != None:
					cmdline = self.getInfoProcByPid( pid )
					bufConnection['pid'] = pid
					bufConnection['cmd'] = cmdline
				else:
					bufConnection['pid'] = ''
					bufConnection['cmd'] = ''
				retList.append( bufConnection )
				#print bufConnection['local_addr'], bufConnection['local_port'], bufConnection['foreign_addr'], bufConnection['foreign_port'], bufConnection['state'], bufConnection['inode']
			except Exception:
				pass
				#print E
		return retList


	def getPidByInode(self, num_inode):
		#self.uidUp()
		pat = self.pat
		listdirVar = listdir("/proc")
		for L in listdirVar:
			try:
				pid_proc = (int)(L)
				list_files_fd = listdir("/proc/%s/fd/"%pid_proc)
				for F in list_files_fd:
					name_file = readlink( "/proc/%s/fd/%s"%(pid_proc,F) )
					m = search(pat, name_file)
					if m != None:
						inode = name_file[8:(len(name_file)-1)]
						if num_inode == (int)(inode):
							return pid_proc
			except ValueError:
				#L - каталог не из чисел (не pid процесса)
				continue
			except OSError:
				#доступ запрещен, нужен root
				pass
		#self.uidDown()
		return None


	def getStrFromFile(self, file):
		res = ""
		try:
			f = open(file,"r")
			res = f.readline()
			f.close()
		except:
			pass
		return res


	def getInfoProcByPid(self, pid):
		cmdline = self.getStrFromFile( "/proc/%s/cmdline"%(pid) )
		return cmdline
		#comm = self.getStrFromFile("/proc/"+pid+"/comm")


