#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
from WinNetStatProc import Ui_WinNetStat
from MyNotify import MyNotify
from DialogRefreshNetstat import Ui_DialogRefreshNetstat
from widgetInfoProc import Ui_widgetViewInfoProc
from SlidingStackedWidget import SlidingStackedWidget
from MyItemDelegate import MyItemDelegate

from os import listdir
from os.path import basename, exists
from string import find, replace, split
from re import compile, search, sub, IGNORECASE

from NetStat import NetStat


class NetStatProc( QtCore.QThread ):
	def __init__(self, parent = None):
		QtCore.QThread.__init__( self, parent )
		self.netstat = NetStat()
		self.listOut = None
		self.flPacket = "tcp"
		self.flResolv = False

	def setParam(self, listOut, flResolv = False):
		self.listOut = list
		self.flResolv = flResolv
	
	def needTCP(self):
		self.flPacket = "tcp"

	def needUDP(self):
		self.flPacket = "udp"

	def run(self):
		if self.flPacket == "tcp":
			self.listOut = self.netstat.getStatTCP( self.flResolv )
		elif self.flPacket == "udp":
			self.listOut = self.netstat.getStatUDP( self.flResolv )
		else:
			return

	
	def getResult(self):
		return self.listOut



class WinNetStatExt( QtGui.QMainWindow ):
	def __init__(self, parent, qset ):
		QtGui.QMainWindow.__init__( self, parent )
		self.parent = parent
		
		try:
			self.setAttribute( QtCore.Qt.WA_Maemo5StackedWindow )
			self.setAttribute( QtCore.Qt.WA_Maemo5ShowProgressIndicator )
			#self.setAttribute( QtCore.Qt.WA_DeleteOnClose )
		except Exception, e:
			pass
			#print "WinNetStatExt::__init__(): Exception setAttribute():" , e

		self.qset = qset

		self.flResolv = False
		self.data = list()

		self.color_background = ""
		self.color_text = ""
		
		self.ui = Ui_WinNetStat()
		self.ui.setupUi( self )
		
		self.procNetstat = NetStatProc( self )
		self.procNetstat.started.connect( self.startNetstat )
		self.procNetstat.finished.connect( self.finishNetstat )
		
		self.noti = MyNotify()

		self.listConn = QtGui.QListWidget( self.ui.ww )
		self.listConn.setGeometry(QtCore.QRect(0, 10, 790, 340))
		self.listConn.setObjectName("listConn")

		self.widgetInfoProc = QtGui.QWidget(self)
		self.ui_procInfo = Ui_widgetViewInfoProc()
		self.ui_procInfo.setupUi( self.widgetInfoProc )
		
		self.flShowInfoProcNow = False
		self.view_info_proc = {}
		self.createSubSlidingWidgets()
		self.createSlidingStackedWidget()

		self.action()

		self.listDesktopFiles = list()
		#self.getInfoDesktopFiles()



	def action(self):
		mainLayout = QtGui.QVBoxLayout()
		mainLayout.addWidget( self.slidingStacked )
		self.ui.ww.setLayout( mainLayout )
		#------------------------------------#
		# виджет ожидания
		self.w_refresh = QtGui.QWidget(self)
		self.w_refresh.setGeometry(QtCore.QRect(670, 10, 130, 50))
		self.w_refresh.setObjectName("w_refresh")
		self.pb_wait_refresh = QtGui.QPushButton(self.w_refresh)
		self.pb_wait_refresh.setGeometry(QtCore.QRect(10, 10, 110, 40))
		self.pb_wait_refresh.setText("")
		icon5 = QtGui.QIcon()
		#icon5.addPixmap(QtGui.QPixmap(":/anim/pictures/anim/reload0.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		icon5.addPixmap(QtGui.QPixmap("/usr/share/icons/hicolor/scalable/hildon/indicator_update1.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.pb_wait_refresh.setIcon(icon5)
		self.pb_wait_refresh.setIconSize(QtCore.QSize(64, 64))
		self.pb_wait_refresh.setFlat(True)
		self.pb_wait_refresh.setObjectName("pb_wait_refresh")
		#------------------------------------#
		icon = QtGui.QIcon()
		icon.addPixmap(QtGui.QPixmap("/usr/share/icons/hicolor/48x48/hildon/general_forward.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.ui.pb_infoProc.setIcon(icon)
		#------------------------------------#

		self.ui.pb_resolve.toggled.connect( self.resolnOnOff )
		self.ui.pb_tcp.toggled.connect( self.tcpView )
		self.ui.pb_udp.toggled.connect( self.udpView )
		self.ui.pb_refresh.toggled.connect( self.refreshData )
		self.ui.pb_autorefresh.toggled.connect( self.autoRefreshData )
		self.ui.pb_infoProc.clicked.connect( self.showInfoProc )

		self.ui.pb_infoProc.setEnabled( False )
		self.listConn.itemClicked.connect( self.itemSelected )
		self.listConn.itemDoubleClicked.connect( self.showInfoProc )

		#self.listIntervalRefresh = [5,10,15,20,30,40,60]
		QtCore.QObject.connect(self.ui.actionRefreshInterval, QtCore.SIGNAL("triggered()"), self.dialogRefreshInterval)
		#------------------------------------#
#		self.defineColor()
#		if ( (self.color_text != "") and (self.color_background != "") ):
#			#self.ui_procInfo.lblDescrText.setTextBackgroundColor( QtGui.QColor(self.color_background) )
#			#palette = self.ui_procInfo.lblDescrText.palette()
#			#palette.setColor(QtGui.QPalette.Base, palette.color(QtGui.QPalette.Window))
#			#self.ui_procInfo.lblDescrText.setPalette( palette )
#			#self.ui_procInfo.lblDescrText.setTextColor( QtGui.QColor(self.color_text) )
#			#self.ui_procInfo.lblDescrText.setStyleSheet("background-color: %s; color: %s;"%(self.color_background, self.color_text))
#			pass
		#------------------------------------#

		self.w_refresh.hide()
		self.pb_wait_refresh.clicked.connect( self.pleaseWait )
		
		self.timeoutAnim = 400
		self.timerAnim = QtCore.QTimer()
		QtCore.QObject.connect( self.timerAnim, QtCore.SIGNAL("timeout()"), self.doAnimRefresh )
		self.listAnimPixmap = list()
		icon = QtGui.QIcon()
		#icon.addPixmap(QtGui.QPixmap(":/anim/pictures/anim/reload0.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		icon.addPixmap(QtGui.QPixmap("/usr/share/icons/hicolor/scalable/hildon/indicator_update1.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.listAnimPixmap.append( icon )
		icon = QtGui.QIcon()
		#icon.addPixmap(QtGui.QPixmap(":/anim/pictures/anim/reload1.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		icon.addPixmap(QtGui.QPixmap("/usr/share/icons/hicolor/scalable/hildon/indicator_update2.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.listAnimPixmap.append( icon )
		icon = QtGui.QIcon()
		#icon.addPixmap(QtGui.QPixmap(":/anim/pictures/anim/reload2.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		icon.addPixmap(QtGui.QPixmap("/usr/share/icons/hicolor/scalable/hildon/indicator_update3.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.listAnimPixmap.append( icon )
		icon = QtGui.QIcon()
		#icon.addPixmap(QtGui.QPixmap(":/anim/pictures/anim/reload3.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		icon.addPixmap(QtGui.QPixmap("/usr/share/icons/hicolor/scalable/hildon/indicator_update4.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.listAnimPixmap.append( icon )
		icon = QtGui.QIcon()
		#icon.addPixmap(QtGui.QPixmap(":/anim/pictures/anim/reload4.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		icon.addPixmap(QtGui.QPixmap("/usr/share/icons/hicolor/scalable/hildon/indicator_update5.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.listAnimPixmap.append( icon )
		icon = QtGui.QIcon()
		#icon.addPixmap(QtGui.QPixmap(":/anim/pictures/anim/reload5.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		icon.addPixmap(QtGui.QPixmap("/usr/share/icons/hicolor/scalable/hildon/indicator_update6.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.listAnimPixmap.append( icon )
		icon = QtGui.QIcon()
		#icon.addPixmap(QtGui.QPixmap(":/anim/pictures/anim/reload6.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		icon.addPixmap(QtGui.QPixmap("/usr/share/icons/hicolor/scalable/hildon/indicator_update7.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.listAnimPixmap.append( icon )
		icon = QtGui.QIcon()
		#icon.addPixmap(QtGui.QPixmap(":/anim/pictures/anim/reload7.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		icon.addPixmap(QtGui.QPixmap("/usr/share/icons/hicolor/scalable/hildon/indicator_update8.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.listAnimPixmap.append( icon )
		self.indxAnim = 0
		
		self.timeoutAutoRefresh = self.qset.refreshInterval_ns()
		self.timerAutoRefresh = QtCore.QTimer()
		QtCore.QObject.connect( self.timerAutoRefresh, QtCore.SIGNAL("timeout()"), self.doAutoRefreshData )

#		self.colorESTABLISHED = QtGui.QColor("#34c924")
#		self.colorLISTEN = QtGui.QColor("#0000ff")
#		self.colorCLOSE_C = QtGui.QColor("#ff0000")
#		self.colorCLOSE_S = QtGui.QColor("#808080")
#		self.colorSYN_S = QtGui.QColor("#ffff00")
#		self.colorSYN_C = QtGui.QColor("#ffa500")
		
		plugin = MyItemDelegate( self, 0 )
		self.listConn.setItemDelegate( plugin )

		self.ui_procInfo.lblDescrText.setFontPointSize(12)

	#функция для первого вызова при создании объекта
	#после того, как вызвали show()
	def initData(self):
		self.flPacket = "tcp"
		self.ui.pb_tcp.setChecked( True )
	
	
	def defineColor(self):
		data = QtCore.QFile( "/etc/hildon/theme/gtk-2.0/gtkrc" )
		if ( data.open(QtCore.QFile.ReadOnly | QtCore.QFile.Truncate) ):
			start=0
			out = QtCore.QTextStream(data) #QTextStream
			while ( not out.atEnd() or (start < 2) ):
				line = out.readLine() #QString
				if ( find("%s"%line, "color[\"DefaultTextColor\"]") != -1 ):
					line = replace(line, "color[\"DefaultTextColor\"]", "")
					line = replace(line, "=", "")
					line = replace(line, "\"", "")
					line = replace(line, "\t", "")
					line = replace(line, " ", "")
					self.color_text = line
					start += 1 #++start
				if ( find("%s"%line,"color[\"DefaultBackgroundColor\"]") != -1 ):
					line = replace(line, "color[\"DefaultBackgroundColor\"]", "")
					line = replace(line, "=", "") 
					line = replace(line, "\"", "")
					line = replace(line, "\t", "")
					line = replace(line, " ", "")
					self.color_background = line
					start += 1 #++start
				
		data.close()


	def createSubSlidingWidgets(self):
		self.slideWidget1 = QtGui.QWidget( self )
		self.slideWidget2 = QtGui.QWidget( self )
		
		slideWidget1layout = QtGui.QVBoxLayout()
		self.slideWidget1.setLayout( slideWidget1layout )

		slideWidget2layout = QtGui.QVBoxLayout()
		self.slideWidget2.setLayout( slideWidget2layout )

		slideWidget1layout.addWidget( self.listConn )
		slideWidget2layout.addWidget( self.widgetInfoProc )


	def createSlidingStackedWidget(self):
		self.slidingStacked = SlidingStackedWidget(self)
		self.slidingStacked.addWidget( self.slideWidget1 )
		self.slidingStacked.addWidget( self.slideWidget2 )
		animTime = 500
		self.slidingStacked.setSpeed( animTime )
		self.slidingStacked.myAnimationFinished.connect( self.animationFinished )


	def animationFinished( self ):
		self.ui.pb_infoProc.setEnabled( True )


	def resolnOnOff(self, checked):
		self.flResolv = checked
		self.getData()


	def tcpView(self, checked):
		if checked:
			self.ui.pb_tcp.setIcon( QtGui.QIcon(QtGui.QPixmap(":/pic128/pictures/tcp_on.png")) )
			self.flPacket = "tcp"
			self.getData()
		else:
			self.ui.pb_tcp.setIcon( QtGui.QIcon(QtGui.QPixmap(":/pic128/pictures/tcp_off.png")) )


	def udpView(self, checked):
		if checked:
			self.ui.pb_udp.setIcon( QtGui.QIcon(QtGui.QPixmap(":/pic128/pictures/udp_on.png")) )
			self.flPacket = "udp"
			self.getData()
		else:
			self.ui.pb_udp.setIcon( QtGui.QIcon(QtGui.QPixmap(":/pic128/pictures/udp_off.png")) )


	def getData(self):
		self.listConn.clear()
		
		if self.flPacket == "tcp":
			self.procNetstat.needTCP()
		elif self.flPacket == "udp":
			self.procNetstat.needUDP()
		else:
			return

		self.procNetstat.setParam( self.data, self.flResolv )

		self.procNetstat.start()


	
	def startNetstat(self):
		self.ui.pb_infoProc.setEnabled( False )
		self.ui.pb_resolve.setEnabled( False )
		self.ui.pb_tcp.setEnabled( False )
		self.ui.pb_udp.setEnabled( False )
		self.ui.pb_refresh.setEnabled( False )
		self.w_refresh.show()
		self.timerAnim.start( self.timeoutAnim )
		

	
	def finishNetstat(self):
		if self.flShowInfoProcNow:
			self.ui.pb_infoProc.setEnabled( True )
		else:
			self.ui.pb_tcp.setEnabled( True )
			self.ui.pb_udp.setEnabled( True )
		self.ui.pb_refresh.setEnabled( True )
		self.ui.pb_resolve.setEnabled( True )
		self.w_refresh.hide()
		self.timerAnim.stop()
		
		self.data = self.procNetstat.getResult()
		find = False
		for cnct in self.data:
			#если отображается не список, а инфа о процессе, то найдем этот процесс в списке и обновим информацию
			if ((self.flShowInfoProcNow) and (find == False)):
				if( cnct['inode'] == self.view_info_proc['inode'] ):
					self.setDataInfoProc( cnct )
					find = True
			item = QtGui.QListWidgetItem()
			if cnct['state'] == 'LISTEN':
				textItem = "%s: %s : %s"%(cnct['state'],cnct['local_addr'],cnct['local_port'])
			else:
				textItem = "%s: %s : %s - %s : %s"%(cnct['state'],cnct['local_addr'],cnct['local_port'],cnct['foreign_addr'],cnct['foreign_port'])

			item.setData( QtCore.Qt.StatusTipRole,textItem )
			if cnct['cmd'] !='':
				item.setData( QtCore.Qt.UserRole+1, cnct['cmd'] )
			else:
				txt_descr = QtGui.QApplication.translate("WinNetStatProcExt", "Information is not available", None, QtGui.QApplication.UnicodeUTF8)
				item.setData( QtCore.Qt.UserRole+1, txt_descr )

			item_pic = ":/pic128/pictures/system.png"
			ip = self.findProgN900( cnct['cmd'] )
			if ip != None:
				item_pic = ip
			cnct['icon'] = item_pic

			item.setData( QtCore.Qt.UserRole+2, item_pic )
			item.setData( QtCore.Qt.UserRole+3, 0 )

			self.listConn.addItem( item )
		#если процесса уже не существует, вернемся назад к списку процессов
		if( (find == False) and (self.flShowInfoProcNow == True) ):
			self.ui.pb_infoProc.clicked.emit()

	
	def refreshData(self, checked):
		if checked:
			self.getData()
			self.ui.pb_refresh.setChecked( False )
			#self.ui.pb_infoProc.setEnabled( False )


	def autoRefreshData(self, checked):
		if checked:
			self.timerAutoRefresh.start( self.timeoutAutoRefresh*1000 )
			txt1 = QtGui.QApplication.translate("WinNetStatProcExt", "Refresh interval:", None, QtGui.QApplication.UnicodeUTF8)
			txt2 = QtGui.QApplication.translate("WinNetStatProcExt", "sec", None, QtGui.QApplication.UnicodeUTF8)
			self.noti.notify( "%s %s %s"%(txt1, self.timeoutAutoRefresh, txt2) )
		else:
			self.timerAutoRefresh.stop()
	

	def doAutoRefreshData(self):
		if ( self.procNetstat.isRunning() == False ):
			self.ui.pb_infoProc.setEnabled( False )
			self.getData()


	def pleaseWait( self ):
		txt = QtGui.QApplication.translate("WinNetStatProcExt", "Please, wait...", None, QtGui.QApplication.UnicodeUTF8)
		self.noti.notify( "%s"%txt )


	def doAnimRefresh(self):
		self.pb_wait_refresh.setIcon( self.listAnimPixmap[ self.indxAnim ] )
		self.indxAnim += 1
		if self.indxAnim > 7:
			self.indxAnim = 0

	
	def showInfoProc(self):
		self.w_refresh.hide()
		self.ui.pb_infoProc.setEnabled( False )
		if self.flShowInfoProcNow:
			self.slidingStacked.slideInPrev()
			txt = QtGui.QApplication.translate("WinNetStatProcExt", "Info", None, QtGui.QApplication.UnicodeUTF8)
			self.ui.pb_infoProc.setText(txt)
			self.flShowInfoProcNow = False
			icon = QtGui.QIcon()
			icon.addPixmap(QtGui.QPixmap("/usr/share/icons/hicolor/48x48/hildon/general_forward.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
			self.ui.pb_infoProc.setIcon(icon)

			self.ui.pb_tcp.setEnabled( True )
			self.ui.pb_udp.setEnabled( True )
		else:
			self.slidingStacked.slideInNext()
			txt = QtGui.QApplication.translate("WinNetStatProcExt", "Back", None, QtGui.QApplication.UnicodeUTF8)
			self.ui.pb_infoProc.setText(txt)
			self.flShowInfoProcNow = True
			icon = QtGui.QIcon()
			icon.addPixmap(QtGui.QPixmap("/usr/share/icons/hicolor/48x48/hildon/general_back.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
			self.ui.pb_infoProc.setIcon(icon)

			self.ui.pb_tcp.setEnabled( False )
			self.ui.pb_udp.setEnabled( False )

	
	def itemSelected( self, item ):
		num_item = self.listConn.row( item )
		self.ui.pb_infoProc.setEnabled( True )
		data = self.data[ num_item ]
		self.setDataInfoProc( data )
	

	#заполняет форму подробной информации о процессе
	def setDataInfoProc(self, data):
		self.view_info_proc = data
		self.ui_procInfo.lblPidValue.setText( "%s"%data['pid'] )
		self.ui_procInfo.lblCommandLine.setText( "%s"%data['cmd'] )
		state = "%s"%data['state']

		self.ui_procInfo.lblForeignAddrText.show()
		self.ui_procInfo.lblForeignAddrValue.show()
		self.ui_procInfo.lblLocalAddrValue.setText( "%s : %s"%(data['local_addr'], data['local_port']) )
		self.ui_procInfo.lblForeignAddrValue.setText( "%s : %s"%(data['foreign_addr'], data['foreign_port']) )

		self.ui_procInfo.lblState.setText( state )
		
		if state == 'LISTEN':
			txt = QtGui.QApplication.translate("WinNetStatProcExt", "Device (normally a server) is waiting for client connection", None, QtGui.QApplication.UnicodeUTF8)
			self.ui_procInfo.lblDescrText.setPlainText( txt )
			self.ui_procInfo.lblForeignAddrText.hide()
			self.ui_procInfo.lblForeignAddrValue.hide()
		elif state == 'SYN_SENT':
			txt = QtGui.QApplication.translate("WinNetStatProcExt", "Device (normally a client) sent a request to connect to another device and is waiting for confirmation (normally from a server).", None, QtGui.QApplication.UnicodeUTF8)
			self.ui_procInfo.lblDescrText.setPlainText( txt )
		elif state == 'SYN_RECV':
			txt = QtGui.QApplication.translate("WinNetStatProcExt", "The device has received a connection request and send the acknowledgment. At the moment, is expected to start the connection.", None, QtGui.QApplication.UnicodeUTF8)
			self.ui_procInfo.lblDescrText.setPlainText( txt )
		elif state == 'ESTABLISHED':
			txt = QtGui.QApplication.translate("WinNetStatProcExt", "The \"steady state\" of an open TCP connection. Data can be exchanged freely once both devices in the connection enter this state. This will continue until the connection is closed.", None, QtGui.QApplication.UnicodeUTF8)
			self.ui_procInfo.lblDescrText.setPlainText( txt )
		elif state == 'CLOSE_WAIT':
			txt = QtGui.QApplication.translate("WinNetStatProcExt", "One of the stages of closing the connection. Connection closing sent the request to the remote device.", None, QtGui.QApplication.UnicodeUTF8)
			self.ui_procInfo.lblDescrText.setPlainText( txt )
		elif state == 'LAST_ACK':
			txt = QtGui.QApplication.translate("WinNetStatProcExt", "The last stage of closing the connection. Connection closing sent the request to the remote device.", None, QtGui.QApplication.UnicodeUTF8)
			self.ui_procInfo.lblDescrText.setPlainText( txt )
		elif state == 'FIN_WAIT1':
			txt = QtGui.QApplication.translate("WinNetStatProcExt", "One of the stages of closing the connection. Connection closing sent the request to the local device.", None, QtGui.QApplication.UnicodeUTF8)
			self.ui_procInfo.lblDescrText.setPlainText( txt )
		elif state == 'FIN_WAIT2':
			txt = QtGui.QApplication.translate("WinNetStatProcExt", "One of the stages of closing the connection. Connection closing sent the request to the local device.", None, QtGui.QApplication.UnicodeUTF8)
			self.ui_procInfo.lblDescrText.setPlainText( txt )
		elif state == 'CLOSING':
			txt = QtGui.QApplication.translate("WinNetStatProcExt", "One of the stages of closing the connection. The simultaneous closure of the connection.", None, QtGui.QApplication.UnicodeUTF8)
			self.ui_procInfo.lblDescrText.setPlainText( txt )
		elif state == 'TIME_WAIT':
			txt = QtGui.QApplication.translate("WinNetStatProcExt", "The last stage of closing the connection. After wait period, the connection pass to the CLOSED state.", None, QtGui.QApplication.UnicodeUTF8)
			self.ui_procInfo.lblDescrText.setPlainText( txt )
		elif state == 'CLOSE':
			txt = QtGui.QApplication.translate("WinNetStatProcExt", "This is the state by default before the connection is established. This is the sitation when there is no any connection between devices : it eather hasn't been created yet, or has just been broken.", None, QtGui.QApplication.UnicodeUTF8)
			self.ui_procInfo.lblDescrText.setPlainText( txt )
		else:
			self.ui_procInfo.lblDescrText.setPlainText("")
			
		if data.has_key('icon'):
			self.ui_procInfo.lblIconProc.setPixmap( QtGui.QPixmap( data['icon'] ) )
		else:
			self.ui_procInfo.lblIconProc.setPixmap( QtGui.QPixmap( ":/pic128/pictures/system.png" ) )

	#---------------------------#

	def mytrim(self, str):
		str = replace( str, " ", "" )
		str = replace( str, "\n", "" )
		return str

	
	def getInfoDesktopFiles(self):
		self.listDesktopFiles = list()

		p = "/usr/share/applications/hildon/"

		listfiles = listdir(p)
		
		#образцы для поиска необходимых строк в *.desktop файлах
		patIcon = compile(r'(^Icon(.)*=)')
		patExec = compile(r'(^Exec(.)*=)')

		#шустрим все desktop файлы
		for FF in listfiles:
			try:
				#считываем все строки файла
				f = open( p+FF, "r")
				lines_file = f.readlines()
				f.close()
				bufDesktopFile = {}
				#ищем две необходимые нам строки Icon и Exec
				for line in lines_file:
					i = search(patIcon, line)
					e = search(patExec, line)

					if i != None:
						str = self.mytrim( sub(patIcon, '', line) )
						bufDesktopFile['icon'] = str
					elif e != None:
						str = self.mytrim( sub(patExec, '', line) )
						bufDesktopFile['exec'] = str
				#если такие строки найдены, запомним их
				if bufDesktopFile.has_key('icon') and bufDesktopFile.has_key('exec'):
					self.listDesktopFiles.append( bufDesktopFile )
			except Exception, E:
				print E

		#print self.listDesktopFiles

	def findProgN900(self,path):
		if path == '':
			return None

		if len( self.listDesktopFiles ) == 0:
			self.getInfoDesktopFiles()

		basemane_path = basename( path )
		for dat in self.listDesktopFiles:
			exec_ = basename( dat['exec'] ) 
			findme = search( exec_, basemane_path, flags=IGNORECASE )
			if findme != None:
				icon1 = "/usr/share/icons/hicolor/24x24/apps/"+dat['icon']+".png"
				icon2 = "/usr/share/icons/hicolor/32x32/apps/"+dat['icon']+".png"
				icon3 = "/usr/share/icons/hicolor/48x48/apps/"+dat['icon']+".png"
				icon4 = "/usr/share/icons/hicolor/64x64/apps/"+dat['icon']+".png"
				icon5 = "/usr/share/icons/hicolor/128x128/apps/"+dat['icon']+".png"
				icon6 = "/usr/share/icons/hicolor/scalable/apps/"+dat['icon']+".png"
				if exists(icon6):
					return icon6
				if exists(icon5):
					return icon5
				if exists(icon4):
					return icon4
				if exists(icon3):
					return icon3
				if exists(icon2):
					return icon2
				if exists(icon1):
					return icon1
		return None

	#------------------------#
	def dialogRefreshInterval(self):
		self.dlg = QtGui.QDialog( )
		self.ui_dlg = Ui_DialogRefreshNetstat()
		self.ui_dlg.setupUi( self.dlg )
		self.ui_dlg.lWinterval.itemClicked.connect( self.setRefreshInterval )
		self.dlg.show()
		self.dlg.exec_()

	def setRefreshInterval(self, indx):
		self.ui_dlg.lWinterval.itemClicked.disconnect( self.setRefreshInterval )
		self.dlg.hide()
		txt = split(indx.text(), ' ')
		self.timeoutAutoRefresh = int( "%s"%txt[0], 10 )
		if self.timerAutoRefresh.isActive():
			self.timerAutoRefresh.stop()
			self.timerAutoRefresh.start( (self.timeoutAutoRefresh*1000) )
		self.qset.setRefreshInterval_ns( self.timeoutAutoRefresh )
