# -*- coding: utf-8 -*-

from PySide import QtCore, QtGui
from DialogComment import Ui_DialogComment




class DialogCommentExt(Ui_DialogComment, QtCore.QObject):
	commentAdd = QtCore.Signal()
	commentDel = QtCore.Signal()
	commentFailed = QtCore.Signal()
		
	new_comment = False

	def __init__(self, dlg, mydb, session_id ):
		QtCore.QObject.__init__(self)
		self.dlg = dlg
		self.setupUi(dlg)

		self.my_db = mydb
		self.session_id = session_id
		self.listSupportIface = self.my_db.optGetSupportIface()

		self.action()

	
	def action(self):
		self.pBSave.clicked.connect( self.saveComment )
		self.pBDelete.clicked.connect( self.deleteComment )


		self.pBSave.setEnabled( False )
		self.tEComment.textChanged.connect( self.textCommentChange )
		
		#get comment from db
		comment = self.my_db.getCommentSession( self.session_id )
		if comment != None:
			self.tEComment.setPlainText( comment )
			self.new_comment = False
			self.pBDelete.setEnabled( True )
		else:
			self.new_comment = True
			self.pBDelete.setEnabled( False )
		
		self.pBSave.setEnabled( False )


	def textCommentChange( self ):
		num_symbols = len( self.tEComment.toPlainText() )
		if num_symbols == 0:
			self.pBSave.setEnabled( False )
		else:
			self.pBSave.setEnabled( True )
	

	def saveComment( self ):
		comment = self.tEComment.toPlainText()
		if comment != None:
			ok = self.my_db.setCommentSession( self.session_id, comment, self.new_comment )
			if ok:
				self.commentAdd.emit()
			else:
				self.commentFailed.emit()

		self.dlg.hide()


	def deleteComment( self ):
		ok = self.my_db.delCommentSession( self.session_id )
		if ok:
			self.commentDel.emit()
		else:
			self.commentFailed.emit()
		self.dlg.hide()
