# -*- coding: utf-8 -*-

from PySide import QtCore, QtGui
from MainWindow import Ui_MainWindow
from ViewCurrentSessionExt import ViewCurrentSessionExt
from OptionsWindowExt import OptionsWindowExt
from ListSessionsExt import ListSessionsExt
from WinAboutExt import WinAboutExt
from WinNetStatExt import WinNetStatExt
from QNMDBusClient import QNMDBusClient

import myconfig
import QNMSettings
from mydb import MyDB

class MainWindowExt( QtGui.QMainWindow ):
	#pvr# def __init__(self, splash, parent = None):
	def __init__(self, parent = None):
		QtGui.QMainWindow.__init__( self, parent )
		self.parent = parent
		
		try:
			self.setAttribute( QtCore.Qt.WA_Maemo5StackedWindow )
			self.setAttribute( QtCore.Qt.WA_Maemo5ShowProgressIndicator )
		except Exception, e:
			pass
			#print "MainWindowExt::__init__(): Exception setAttribute():" , e
		
		self.db = MyDB( myconfig.file_db )
		
		self.mydbus = QNMDBusClient()
		retVal = self.mydbus.connectDBus()
		if retVal == False:
			#splash.finish(self)
			#splash.finish(self)
			txt = QtGui.QApplication.translate("MainWindowExt", "Daemon QNetMan is not running.\nStart daemons now ?", None, QtGui.QApplication.UnicodeUTF8)
			txt_w = QtGui.QApplication.translate("MainWindowExt", "Warning", None, QtGui.QApplication.UnicodeUTF8)
			r = QtGui.QMessageBox.question(self, txt_w, txt, QtGui.QMessageBox.Ok, QtGui.QMessageBox.Cancel)
			if r == QtGui.QMessageBox.Ok:
				res = self.daemonStart()
				if res:
					txt1 = QtGui.QApplication.translate("MainWindowExt", "Information", None, QtGui.QApplication.UnicodeUTF8)
					txt2 = QtGui.QApplication.translate("MainWindowExt", "Please restart the program now.", None, QtGui.QApplication.UnicodeUTF8)
					QtGui.QMessageBox.information( self, txt1, txt2 )
				else:
					txt1 = QtGui.QApplication.translate("MainWindowExt", "Error", None, QtGui.QApplication.UnicodeUTF8)
					txt2 = QtGui.QApplication.translate("MainWindowExt", "Failed to start daemon.", None, QtGui.QApplication.UnicodeUTF8)
					QtGui.QMessageBox.critical( self, txt1, txt2 )
			else:
				txt = QtGui.QApplication.translate("MainWindowExt", "Features will be limited.", None, QtGui.QApplication.UnicodeUTF8)
				QtGui.QMessageBox.information( self, txt_w, txt)

		self.ui = Ui_MainWindow()
		self.ui.setupUi( self )
		
		#настройки в конфигурационном файле
		self.qset = QNMSettings.QNMSettings( myconfig.file_setting, self )

		self.windowRealTime = ViewCurrentSessionExt( self, self.db, self.mydbus, self.qset )
		self.windowRealTime.hide()
		

		self.windowOptions = OptionsWindowExt( self, self.db, self.mydbus )
		self.windowOptions.hide()

		self.windowAbout = WinAboutExt( self )
		self.windowAbout.hide()
		
		self.windowConnections = WinNetStatExt( self )
		self.windowConnections.hide()

		self.actionForm()

		#splash.finish(self)
		

	def actionForm(self):
		self.ui.pushButtonRealTime.clicked.connect( self.showRealTime )
		self.ui.pushButtonSession.clicked.connect( self.showListSessions )
		self.ui.pushButtonOption.clicked.connect( self.showOptions )
		self.ui.pushButtonConnections.clicked.connect( self.showConnections )
		QtCore.QObject.connect(self.ui.actionAbout, QtCore.SIGNAL("triggered()"), self.windowAbout.show )
	
	def showRealTime(self):
		self.windowRealTime.show()

	def showListSessions(self):
		self.windowListSessions = ListSessionsExt( self, self.db, self.qset )
		self.windowListSessions.show()
		self.windowListSessions.activateFilter()

	def showOptions(self):
		self.windowOptions.show()

	def showConnections(self):
		self.windowConnections.show()
		self.windowConnections.showData()
	

	def daemonStart(self):
		prg = "/opt/maemo/usr/bin/qnetmand"
		b = QtCore.QProcess.startDetached( prg )
		return b

