#!/usr/bin/env python
# -*- coding: utf-8 -*-

import gtk
import cairo
import gobject
import gconf

from sys import path
path.extend(['/opt/qnetman/'])
#path.extend(['/home/tolik/develop/qnetman'])

from pysrc import gettraff

import hildondesktop
import hildon

#import time

class SingleObject(object):
	_instance = None
	_references = 0
	def __new__(cls, *args, **kwargs):
		cls._references += 1
		if not cls._instance:
			cls._instance = super(SingleObject, cls).__new__( cls, *args, **kwargs )
		return cls._instance


class Config(SingleObject):
	path="/apps/qnetmanwidget"
	path_refr_int = path + "/refresh_interval"
	path_vis_net_iface = path + "/network_interfaces"
	
	observers = []

	def __init__(self):
		if self._references > 1:
			return
		self.client = gconf.client_get_default()
		self.client.add_dir( '/apps/qnetmanwidget', gconf.CLIENT_PRELOAD_RECURSIVE )
		self.notify_id = self.client.notify_add( '/apps/qnetmanwidget', self.gconf_changed )

	def add_observer(self, func):
		try:
			self.observers.index(func)
		except:
			self.observers.append(func)
			func()

	def remove_observer(self, func):
		self.observers.remove(func)

	def gconf_changed(self, client, *args, **kargs):
		self.notify()

	def notify(self):
		#t1 = time.time()
		for func in self.observers:
			func()
		#t2 = time.time()
		#print "Update took: %f seconds" % (t2-t1)
	
	def set_refresh_interval(self, value):
		self.client.set_int( self.path_refr_int, value )
	
	def get_refresh_interval(self):
		return self.client.get_int( self.path_refr_int )

	def set_show_iface(self,value):
		self.client.set_list( self.path_vis_net_iface, gconf.VALUE_STRING, value )
	
	def get_show_iface( self ):
		return self.client.get_list( self.path_vis_net_iface, gconf.VALUE_STRING )


class CustomEventBox(gtk.EventBox):
	def __init__(self):
		gtk.EventBox.__init__(self)
    
	def fail_do_expose_event(self, e):
		self.cr = self.window.cairo_create()

		self.cr.rectangle( e.area.x, e.area.y, e.area.width, e.area.height )
		self.cr.clip()
		rect = self.get_allocation()
		self.cr.rectangle(rect.x, rect.y, rect.width, rect.height)

		style = self.rc_get_style()
		if self.state == gtk.STATE_ACTIVE:
			color = style.lookup_color("SelectionColor")
			self.cr.set_source_rgba (color.red / 65535.0, color.green / 65335.0, color.blue / 65535.0, 0.3)
		else:
			color = style.lookup_color("DefaultBackgroundColor")
			self.cr.set_source_rgba (color.red / 65535.0, color.green / 65335.0, color.blue / 65535.0, 0.6)

		#style = self.rc_get_style()
		#color = style.lookup_color("DefaultBackgroundColor")
		#self.cr.set_source_rgba (color.red / 65535.0, color.green / 65335.0, color.blue / 65535.0, 0.5)
		self.cr.fill()
		hildondesktop.HomePluginItem.do_expose_event(self,e)


class QNetManHomePlugin(hildondesktop.HomePluginItem):
	myconfig = None
	
	listShowIface = []
	refresh_interval_seconds = 0

	def __init__(self):
		hildondesktop.HomePluginItem.__init__( self )
		
		gobject.type_register(CustomEventBox)

		self.myconfig = Config()

		#config
		self.refresh_interval_seconds = self.myconfig.get_refresh_interval()
		#print self.refresh_interval_seconds

		self.listIface = []
		self.listIface.append("gprs0")
		self.listIface.append("wlan0")
		self.listIface.append("eth0")
		self.listIface.append("usb0")
		self.listIface.append("pan0")
		self.listIface.append("ppp0")

		self.listShowIface = self.myconfig.get_show_iface()
		#print self.listShowIface

		if len(self.listShowIface) == 0:
			self.listShowIface.append("gprs0")
			self.myconfig.set_show_iface( self.listShowIface )
		

		self.listRefreshInterval = []
		self.listRefreshInterval.append(0)    # on click
		self.listRefreshInterval.append(2)    # 2 sec
		self.listRefreshInterval.append(5)    # 5 sec
		self.listRefreshInterval.append(10)   # 10 sec
		self.listRefreshInterval.append(30)   # 30 sec
		self.listRefreshInterval.append(60)   # 1 min
		self.listRefreshInterval.append(180)  # 3 min
		self.listRefreshInterval.append(300)  # 5 min
		
		self.listShowIfaceTemp = list( self.listShowIface )
		
		self.bufLabelTraff = {}
		

		self.id_timeout = None
		self.initHomescreenWidget()

		self.set_settings(True)
		self.connect("show-settings", self.show_settings)
		self.dialog = None

	
	def initHomescreenWidget(self):
		
		listChildreWidget = self.get_children()
		for child in listChildreWidget:
			self.remove( child )

		vbox = gtk.VBox( False, 0 )
		for iface in self.listShowIface:
			hw = self.addIfaceWidget(iface)
			vbox.pack_start(hw, True, True, 0)
			vbox.show_all()

		eventBox = CustomEventBox()
		eventBox.set_visible_window(False)
		eventBox.connect("button-press-event", self.eventBox_clicked)
		eventBox.connect("button-release-event", self.eventBox_clicked_release)
		eventBox.add(vbox)
		eventBox.show_all()
        
		self.add(eventBox)
		
		self.updateMyWidget()

	def new_label_my(self, title=""):
		l = gtk.Label(title)
		hildon.hildon_helper_set_logical_font(l, "SmallSystemFont")
		return l
    
	def eventBox_clicked(self, widget, data=None):
		widget.set_state(gtk.STATE_ACTIVE)
		if self.refresh_interval_seconds == 0:
			self.updateMyWidget()

	def eventBox_clicked_release(self, widget, data=None):
		widget.set_state(gtk.STATE_NORMAL)

	
	def addIfaceWidget(self, iface):
		hbox = gtk.HBox(False,0)

		img_iface = self.pictureIface( iface )
		hbox.pack_start(img_iface, False, True, 0)
		
		label_rx = gtk.Label()
		label_tx = gtk.Label()
		
		self.bufLabelTraff[ iface+"_label_rx" ] = label_rx
		self.bufLabelTraff[ iface+"_label_tx" ] = label_tx
		
		hbox.pack_start(label_rx, True, False, 0)
		hbox.pack_start(label_tx, True, False, 0)

		return hbox

	# --- cairo function --- #
	def do_expose_event(self, e):
		cr = self.window.cairo_create()

		cr.rectangle( e.area.x, e.area.y, e.area.width, e.area.height )
		cr.clip()
		rect = self.get_allocation()
		cr.rectangle(rect.x, rect.y, rect.width, rect.height)

		style = self.rc_get_style()
		color = style.lookup_color("DefaultBackgroundColor")
		cr.set_source_rgba (color.red / 65535.0, color.green / 65335.0, color.blue / 65535.0, 0.6);
		cr.fill()
		hildondesktop.HomePluginItem.do_expose_event(self,e)

	def do_realize(self):
		scn = self.get_screen()
		cm = scn.get_rgba_colormap()
		self.set_colormap(scn.get_rgba_colormap())
		self.set_app_paintable(True)
		hildondesktop.HomePluginItem.do_realize(self)
	
	#--------------------#
	def pictureIface( self, iface ):
		prefix_path = "/opt/qnetman/pysrc/pictures/"
		#prefix_path = "/home/user/develop/qnetman/pysrc/pictures/"
		png = prefix_path + "unknown.png"
		if iface == "gprs0":
			png = prefix_path + "gprs.png"
		elif iface == "wlan0":
			png = prefix_path + "wifi.png"
		elif iface == "eth0":
			png = prefix_path + "eth.png"
		elif iface == "usb0":
			png = prefix_path + "usb.png"
		elif iface == "pan0":
			png = prefix_path + "pan.png"

		image_iface = gtk.Image()
		image_iface.set_from_file( png )

		return image_iface
	#--------------------#
	def updateMyWidget(self):
		for iface in self.listShowIface:
			if ( (self.bufLabelTraff.has_key( iface + "_label_rx" )) and (self.bufLabelTraff.has_key( iface + "_label_tx" )) ):
				label_rx = self.bufLabelTraff[ iface + "_label_rx" ]
				label_tx = self.bufLabelTraff[ iface + "_label_tx" ]
				rx, tx, ok = self.getTraff(iface)
				if ok:
					rx = self.humanBytes( rx )
					tx = self.humanBytes( tx )
					label_rx.set_text("  RX: %s "%rx)
					label_tx.set_text("  TX: %s "%tx)
				else:
					label_rx.set_text(" OFFLINE ")
					label_tx.set_text("")
				#print "updateMyWidget(): rx=%s  tx=%s"%(rx,tx)
		if self.refresh_interval_seconds != 0:
			self.id_timeout = gobject.timeout_add_seconds( self.refresh_interval_seconds, self.updateMyWidget )
		#print
	
	#--------------------#
	def getTraff(self, iface):
		gt = gettraff.GetTraff(iface)
		return gt.getCurrBytes()

	def humanBytes(self, bytes):
		bytes = int( bytes )
		strRet = ""
		if (bytes/1024) > 1048576:
			strRet = "%.2f GB"%( bytes/1048576.0/1024.0 )
		elif bytes > 1048576:
			strRet = "%.2f MB"%( bytes/1048576.0 )
		elif bytes > 1024:
			strRet = "%.2f kB"%( bytes/1024.0 )
		else:
			strRet = "%s B"%( bytes )
		return strRet

	#------- settings --------#
	def showDialogSelectedIface(self):
		self.listShowIfaceTemp = list( self.listShowIface )

		def ifaceButton_changed(ifaceButton):
			iface = ifaceButton.get_label()
			if ifaceButton.get_active():
				try:
					indx = self.listShowIfaceTemp.index( iface )
				except ValueError:
					self.listShowIfaceTemp.append( iface )
				#print "show: %s %s"%(iface, len(self.listShowIfaceTemp))
			else:
				if len(self.listShowIfaceTemp) == 1:
					hildon.hildon_banner_show_information(self, "None", "You can not disable all network interfaces !")
					ifaceButton.set_active(True)
					return
				try:
					indx = self.listShowIfaceTemp.remove( iface )
				except ValueError:
					pass

		dialog = gtk.Dialog()
		dialog.set_title("Network interfaces")
		#dialog.add_button("OK", gtk.RESPONSE_OK)
		
		pan_area = hildon.PannableArea()
		vbox = gtk.VBox()

		listButtonIfaces = []
		for iface in self.listIface:
			ifaceButton = hildon.CheckButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
			ifaceButton.set_label( iface )
			#img = self.pictureIface( iface )
			#ifaceButton.set_image( img )
			try:
				indx = self.listShowIfaceTemp.index( iface )
				ifaceButton.set_active(True)
			except ValueError:
				ifaceButton.set_active(False)
			ifaceButton.connect("toggled", ifaceButton_changed)
			vbox.add( ifaceButton )

		pan_area.add_with_viewport(vbox)
		pan_area.set_size_request(-1, 300)

		dialog.vbox.add(pan_area)
		dialog.show_all()

		response = dialog.run()
		dialog.destroy()

	def show_settings(self, widget):
		self.refreshInterval_indx = 0
		self.netIface_indx = ""
		def selectorTimeout_changed( selector, data ):
			self.refreshInterval_indx = selector.get_active(0)
		
		def selectorIface_changed( selector, data ):
			self.netIface_indx = selector.get_current_text()

		def showDlgSelIface(widget):
			self.showDialogSelectedIface()

		dialog = gtk.Dialog()
		dialog.set_title("Settings")
		dialog.add_button("OK", gtk.RESPONSE_OK)
		dialog.add_button("About", gtk.RESPONSE_HELP)
		self.dialog = dialog

		# ---- opt refresh interval ---- #
		selectorTimeout = hildon.TouchSelector(text=True)
		selectorTimeout.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
		for ri in self.listRefreshInterval:
			if ri == 0:
				selectorTimeout.append_text("On click")
			else:
				selectorTimeout.append_text("%s seconds"%ri)
		selectorTimeout.connect("changed", selectorTimeout_changed)
        
		refreshInterval = hildon.PickerButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		refreshInterval.set_alignment(0.0, 0.5, 1.0, 1.0)
		refreshInterval.set_title("Refresh interval")
		refreshInterval.set_selector(selectorTimeout)
		refresh_interval_string_indx = self.listRefreshInterval.index( self.refresh_interval_seconds )
		refreshInterval.set_active( refresh_interval_string_indx )

		# ---- opt network interface ---- #
		nifButton = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		nifButton.set_title("Network interfaces")
		nifButton.set_value("Select the network interface for display on the widget")
		nifButton.set_alignment(0, 0.8, 1, 1)
		nifButton.connect("clicked", showDlgSelIface)
		#------------------------------#

		pan_area = hildon.PannableArea()
		vbox = gtk.VBox()
		vbox.add(refreshInterval)
		vbox.add(nifButton)

		pan_area.add_with_viewport(vbox)
		pan_area.set_size_request(-1, 140)

		dialog.vbox.add(pan_area)
		dialog.show_all()

		while 1:
			response = dialog.run()

			if response == gtk.RESPONSE_HELP:
				self.show_about()
				break
		
			if response == gtk.RESPONSE_OK:
				#remove event source (timeout_add_seconds)
				if self.id_timeout != None:
					r = gobject.source_remove( self.id_timeout )
					if r:
						self.id_timeout = None
	
				try:
					#refresh interval settings
					self.refresh_interval_seconds = self.listRefreshInterval[ self.refreshInterval_indx ]
					self.myconfig.set_refresh_interval( self.refresh_interval_seconds )
	
					#the list network interfaces settings
					self.listShowIface = list( self.listShowIfaceTemp )
					self.myconfig.set_show_iface( self.listShowIface )
	
					#reinit the widget
					self.initHomescreenWidget()
   	     		
					#resize the widget
					x,y = self.size_request()
					self.resize(x,y)
	
					break
				except Exception, e:
					#print e
					hildon.hildon_banner_show_information(self, "None", "Invalid")

		dialog.destroy()


	def show_about(self):
		dialog = gtk.Dialog()
		dialog.set_title("About")
		
		#pan_area = hildon.PannableArea()
		hbox = gtk.VBox()

		lbl = gtk.Label()
		lbl.set_markup("<big>QNetMan homescreen widget</big>")
		hbox.pack_start(lbl, True, True, 0)
		
		lbl_space = gtk.Label()
		lbl_space.set_markup("<big></big>")
		hbox.pack_start(lbl_space, True, True, 0)

		lbl_version = gtk.Label()
		lbl_version.set_markup("<small>Version: 0.0.1 (alpha)</small>")
		hbox.pack_start(lbl_version, True, True, 0)
		
		lbl_author = gtk.Label()
		lbl_author.set_markup("<small>Author: Anatoliy Kozlov</small>")
		hbox.pack_start(lbl_author, True, True, 0)
		#vbox.show_all()
		
		#pan_area.add_with_viewport(vbox)
		#pan_area.set_size_request(-1, 200)

		dialog.vbox.add(hbox)
		dialog.show_all()
		
		response = dialog.run()
		dialog.destroy()




hd_plugin_type = QNetManHomePlugin

if __name__ == "__main__":
	import gobject
	gobject.type_register(hd_plugin_type)
	obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
	obj.show_all()
	gtk.main()
