#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PySide import QtCore

class QNMSettings(QtCore.QSettings):
	def __init__(self, fileSetting, parent = None):
		QtCore.QSettings.__init__( self, fileSetting, QtCore.QSettings.IniFormat, parent  )

		self.groupMonitorOpt = "monitor"
		self.key_graphType = "graph_type"
		self.key_showRule = "show_ruler"
		self.key_showRX = "show_rx"
		self.key_showTX = "show_tx"
		self.key_timestamp = "timestamp"


	#----------------------------------#
	def setTypeGraphStat( self ):
		self.beginGroup( self.groupMonitorOpt )
		self.setValue(self.key_graphType,"0")
		self.endGroup()
	
	def setTypeGraphTime( self ):
		self.beginGroup( self.groupMonitorOpt )
		self.setValue(self.key_graphType, "1")
		self.endGroup()

	def isTypeGrapStat(self):
		self.beginGroup( self.groupMonitorOpt )
		val = self.value( self.key_graphType, "0" )
		self.endGroup()
		if val == "0":
			return True
		else:
			return False
	
	def isTypeGrapTime(self):
		self.beginGroup( self.groupMonitorOpt )
		val = self.value( self.key_graphType, "1" )
		self.endGroup()
		if val == "1":
			return True
		else:
			return False
	
	def typeGraph(self):
		self.beginGroup( self.groupMonitorOpt )
		val = self.value( self.key_graphType, "0" )
		self.endGroup()
		if val == "1":
			return 1
		else:
			return 0
	
	#----------------------------------#
	def showRuler(self, show):
		self.beginGroup( self.groupMonitorOpt )
		if show:
			self.setValue(self.key_showRule, "1")
		else:
			self.setValue(self.key_showRule, "0")
		self.endGroup()

	def isShowRuler(self):
		self.beginGroup( self.groupMonitorOpt )
		val = self.value( self.key_showRule, "0" )
		self.endGroup()
		if val == "0":
			return False
		else:
			return True
	
	
	#----------------------------------#
	def showRX(self, show):
		self.beginGroup( self.groupMonitorOpt )
		if show:
			self.setValue(self.key_showRX, "1")
		else:
			self.setValue(self.key_showRX, "0")
		self.endGroup()

	def isShowRX(self):
		self.beginGroup( self.groupMonitorOpt )
		val = self.value( self.key_showRX, "1" )
		self.endGroup()
		if val == "0":
			return False
		else:
			return True
	
	
	#----------------------------------#
	def showTX(self, show):
		self.beginGroup( self.groupMonitorOpt )
		if show:
			self.setValue(self.key_showTX, "1")
		else:
			self.setValue(self.key_showTX, "0")
		self.endGroup()

	def isShowTX(self):
		self.beginGroup( self.groupMonitorOpt )
		val = self.value( self.key_showTX, "1" )
		self.endGroup()
		if val == "0":
			return False
		else:
			return True
	
	
	#----------------------------------#
	def setTimestamp(self, seconds):
		self.beginGroup( self.groupMonitorOpt )
		self.setValue(self.key_timestamp, seconds)
		self.endGroup()

	def timestamp(self):
		self.beginGroup( self.groupMonitorOpt )
		val = self.value( self.key_timestamp, "30" )
		self.endGroup()
		val = (int)(val)
		return val

