#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PySide import QtCore, QtGui
from WinNetStat import Ui_WinNetStat
from MyNotify import MyNotify
from DialogRefreshNetstat import Ui_DialogRefreshNetstat

import string
import re




class WinNetStatExt( QtGui.QMainWindow ):
	def __init__(self, parent = None):
		QtGui.QMainWindow.__init__( self, parent )
		self.parent = parent
		
		try:
			self.setAttribute( QtCore.Qt.WA_Maemo5StackedWindow )
			self.setAttribute( QtCore.Qt.WA_Maemo5ShowProgressIndicator )
			#self.setAttribute( QtCore.Qt.WA_DeleteOnClose )
		except Exception, e:
			pass
			#print "WinNetStatExt::__init__(): Exception setAttribute():" , e

		self.flResolv = False
		self.data = list()
		
		self.ui = Ui_WinNetStat()
		self.ui.setupUi( self )
		
		self.procNetstat = QtCore.QProcess( self )
		self.procNetstat.started.connect( self.startNetstat )
		
		self.procGrep = QtCore.QProcess( self )
		self.procGrep.readyReadStandardOutput.connect( self.readNetstat )
		self.procGrep.finished.connect( self.finishNetstat )
		
		self.noti = MyNotify()

		self.action()

		self.ui.tableWidget.setEditTriggers( QtGui.QAbstractItemView.NoEditTriggers )


	
	def action(self):
		self.ui.pb_resolve.toggled.connect( self.resolnOnOff )
		self.ui.pb_tcp.toggled.connect( self.tcpView )
		self.ui.pb_udp.toggled.connect( self.udpView )
		self.ui.pb_refresh.toggled.connect( self.refreshData )
		self.ui.pb_autorefresh.toggled.connect( self.autoRefreshData )

		#self.listIntervalRefresh = [5,10,15,20,30,40,60]
		QtCore.QObject.connect(self.ui.actionRefreshInterval, QtCore.SIGNAL("triggered()"), self.dialogRefreshInterval)

		self.flPacket = "tcp"
		self.ui.pb_tcp.setChecked( True )
		
		self.ui.w_refresh.hide()
		self.ui.pb_wait_refresh.clicked.connect( self.pleaseWait )
		
		self.timeoutAnim = 500
		self.timerAnim = QtCore.QTimer()
		QtCore.QObject.connect( self.timerAnim, QtCore.SIGNAL("timeout()"), self.doAnimRefresh )
		self.listAnimPixmap = list()
		icon = QtGui.QIcon()
		icon.addPixmap(QtGui.QPixmap(":/anim/pictures/anim/reload0.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.listAnimPixmap.append( icon )
		icon = QtGui.QIcon()
		icon.addPixmap(QtGui.QPixmap(":/anim/pictures/anim/reload1.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.listAnimPixmap.append( icon )
		icon = QtGui.QIcon()
		icon.addPixmap(QtGui.QPixmap(":/anim/pictures/anim/reload2.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.listAnimPixmap.append( icon )
		icon = QtGui.QIcon()
		icon.addPixmap(QtGui.QPixmap(":/anim/pictures/anim/reload3.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.listAnimPixmap.append( icon )
		icon = QtGui.QIcon()
		icon.addPixmap(QtGui.QPixmap(":/anim/pictures/anim/reload4.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.listAnimPixmap.append( icon )
		icon = QtGui.QIcon()
		icon.addPixmap(QtGui.QPixmap(":/anim/pictures/anim/reload5.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.listAnimPixmap.append( icon )
		icon = QtGui.QIcon()
		icon.addPixmap(QtGui.QPixmap(":/anim/pictures/anim/reload6.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.listAnimPixmap.append( icon )
		icon = QtGui.QIcon()
		icon.addPixmap(QtGui.QPixmap(":/anim/pictures/anim/reload7.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
		self.listAnimPixmap.append( icon )
		self.indxAnim = 0
		
		self.timeoutAutoRefresh = 30000 # 30 sec
		self.timerAutoRefresh = QtCore.QTimer()
		QtCore.QObject.connect( self.timerAutoRefresh, QtCore.SIGNAL("timeout()"), self.doAutoRefreshData )

		self.colorESTABLISHED = QtGui.QColor("#34c924")
		self.colorLISTEN = QtGui.QColor("#0000ff")
		self.colorCLOSE_C = QtGui.QColor("#ff0000")
		self.colorCLOSE_S = QtGui.QColor("#808080")
		self.colorSYN_S = QtGui.QColor("#ffff00")
		self.colorSYN_C = QtGui.QColor("#ffa500")


	def resolnOnOff(self, checked):
		self.flResolv = checked
		self.getData()

	def tcpView(self, checked):
		if checked:
			self.ui.pb_tcp.setIcon( QtGui.QPixmap(":/pic128/pictures/tcp_on.png") )
			self.flPacket = "tcp"
			self.getData()
		else:
			self.ui.pb_tcp.setIcon( QtGui.QPixmap(":/pic128/pictures/tcp_off.png") )
	
	def udpView(self, checked):
		if checked:
			self.ui.pb_udp.setIcon( QtGui.QPixmap(":/pic128/pictures/udp_on.png") )
			self.flPacket = "udp"
			self.getData()
		else:
			self.ui.pb_udp.setIcon( QtGui.QPixmap(":/pic128/pictures/udp_off.png") )

	def parserData(self, str):
		self.data = list()
		listRows = string.split(str,'\n')
		for row in listRows:
			el = re.split("\s+",row)
			if len(el) > 1:
				self.data.append(el)
		
		siz_data = len( self.data )
		if siz_data > 0:
			c = 0
			r = self.ui.tableWidget.rowCount()
			for data_row in self.data:
				if( len(self.data[c]) >= 6 ):
					self.ui.tableWidget.setRowCount( c + r + 1 )
					st = self.data[c][5]
					it = QtGui.QTableWidgetItem( " "+st+"  " )
					if st == "ESTABLISHED":
						it.setData( QtCore.Qt.DecorationRole, self.colorESTABLISHED )
					elif ( (st=="LISTEN") ):
						it.setData( QtCore.Qt.DecorationRole, self.colorLISTEN )
					elif ( (st=="SYN_RECV") ):
						it.setData( QtCore.Qt.DecorationRole, self.colorSYN_C )
					elif ( (st=="SYN_SENT") ):
						it.setData( QtCore.Qt.DecorationRole, self.colorSYN_S )
					elif ( (st=="FIN_WAIT1") or (st=="FIN_WAIT2") or (st=="CLOSING") or (st=="TIME_WAIT")):
						it.setData( QtCore.Qt.DecorationRole, self.colorCLOSE_C )
					elif ( (st=="CLOSE_WAIT") or (st=="LAST_ACK") ):
						it.setData( QtCore.Qt.DecorationRole, self.colorCLOSE_S )
					elif ( (st=="CLOSED") ):
						it.setData(QtCore.Qt.DecorationRole, self.colorLISTEN)
					self.ui.tableWidget.setItem(c+r, 0, it )
					self.ui.tableWidget.setItem(c+r, 1, QtGui.QTableWidgetItem("  "+self.data[c][3]+"  ") )
					self.ui.tableWidget.setItem(c+r, 2, QtGui.QTableWidgetItem("  "+self.data[c][4]+"  ") )
					c += 1
		self.ui.tableWidget.resizeColumnsToContents()

	def showData(self):
		pass

	
	def getData(self):
		cmdNetstat = "/bin/netstat"
		argNetstat = list()
		argNetstat.append("-a")
		if not self.flResolv:
			argNetstat.append("-n")

		if self.flPacket == "tcp":
			argNetstat.append("-t")
		elif self.flPacket == "udp":
			argNetstat.append("-u")
		else:
			return

		cmdGrep = "/bin/grep"
		argGrep = list()
		argGrep.append( self.flPacket )

		self.procNetstat.setStandardOutputProcess( self.procGrep )

		self.procNetstat.start( cmdNetstat, argNetstat )
		self.procGrep.start( cmdGrep, argGrep )


	def readNetstat(self):
		bAOutput = self.procGrep.readAllStandardOutput()
		bAError = self.procGrep.readAllStandardError()
		
		self.parserData( bAOutput.__str__() )


	def startNetstat(self):
		self.ui.pb_resolve.setEnabled( False )
		self.ui.pb_tcp.setEnabled( False )
		self.ui.pb_udp.setEnabled( False )
		self.ui.pb_refresh.setEnabled( False )
		self.ui.w_refresh.show()
		self.timerAnim.start( self.timeoutAnim )
		
		self.ui.tableWidget.clearContents()
		self.ui.tableWidget.setRowCount( 0 )

	
	def finishNetstat(self):
		self.ui.pb_resolve.setEnabled( True )
		self.ui.pb_tcp.setEnabled( True )
		self.ui.pb_udp.setEnabled( True )
		self.ui.pb_refresh.setEnabled( True )
		self.ui.w_refresh.hide()
		self.timerAnim.stop( )

	
	def refreshData(self, checked):
		if checked:
			self.getData()
			self.ui.pb_refresh.setChecked( False )

	def autoRefreshData(self, checked):
		if checked:
			self.timerAutoRefresh.start( self.timeoutAutoRefresh )
			txt1 = QtGui.QApplication.translate("WinNetStatExt", "Refresh interval:", None, QtGui.QApplication.UnicodeUTF8)
			txt2 = QtGui.QApplication.translate("WinNetStatExt", "sec", None, QtGui.QApplication.UnicodeUTF8)
			self.noti.notify( "%s %s %s"%(txt1, (self.timeoutAutoRefresh/1000), txt2) )
		else:
			self.timerAutoRefresh.stop()
	
	def doAutoRefreshData(self):
		if (self.procGrep.state() == QtCore.QProcess.NotRunning) and (self.procNetstat.state() == QtCore.QProcess.NotRunning):
			self.getData()

	def pleaseWait( self ):
		txt = QtGui.QApplication.translate("WinNetStatExt", "Please, wait...", None, QtGui.QApplication.UnicodeUTF8)
		self.noti.notify( "%s"%txt )

	def doAnimRefresh(self):
		self.ui.pb_wait_refresh.setIcon( self.listAnimPixmap[ self.indxAnim ] )
		self.indxAnim += 1
		if self.indxAnim > 7:
			self.indxAnim = 0
	
	#------------------------#
	def dialogRefreshInterval(self):
		self.dlg = QtGui.QDialog( )
		self.ui_dlg = Ui_DialogRefreshNetstat()
		self.ui_dlg.setupUi( self.dlg )
		self.ui_dlg.lWinterval.itemClicked.connect( self.setRefreshInterval )
		self.dlg.show()
		self.dlg.exec_()

	def setRefreshInterval(self, indx):
		self.ui_dlg.lWinterval.itemClicked.disconnect( self.setRefreshInterval )
		self.dlg.hide()
		txt = string.split(indx.text(), ' ')
		self.timeoutAutoRefresh = ((int)(txt[0]))*1000
		if self.timerAutoRefresh.isActive():
			self.timerAutoRefresh.stop()
			self.timerAutoRefresh.start( self.timeoutAutoRefresh )
