import QtQuick 1.0

Item {
    id: root

    property Item currentTab: tabView.currentItem.item
    property int index: tabView.currentIndex

    function setTab(tabIndex) {
        tabView.currentIndex = tabIndex;
    }

    function addTab(item, tabIndex) {
        var loader = tabModel.children[tabIndex];
        if (Qt.isQtObject(item)) {
            loader.sourceComponent = item;
        }
        else {
            loader.source = item;
        }
        tabView.currentIndex = tabIndex;
        return tabView.currentItem.item;
    }

    anchors.fill: parent

    VisualItemModel {
        id: tabModel

        Loader {
            width: root.width
            height: root.height
            opacity: index == tabView.currentIndex ? 1 : 0
        }

        Loader {
            width: root.width
            height: root.height
            opacity: index == tabView.currentIndex ? 1 : 0
        }

        Loader {
            width: root.width
            height: root.height
            opacity: index == tabView.currentIndex ? 1 : 0
        }

        Loader {
            width: root.width
            height: root.height
            opacity: index == tabView.currentIndex ? 1 : 0
        }

        Loader {
            width: root.width
            height: root.height
            opacity: index == tabView.currentIndex ? 1 : 0
        }

        Loader {
            width: root.width
            height: root.height
            opacity: index == tabView.currentIndex ? 1 : 0
        }
    }

    ListView {
        id: tabView

        anchors.fill: parent
        model: tabModel
        orientation: ListView.Horizontal
        interactive: false
        highlightMoveDuration: 100
    }
}

