import QtQuick 1.0
import "components"
import "scripts/dateandtime.js" as DT

Item {
    id: delegate

    property bool checked

    signal clicked
    signal pressAndHold
    signal playClicked

    width: parent.width
    height: 150
    smooth: true

    ListHighlight {
        visible: (mouseArea.pressed) || (delegate.checked)
    }

    Label {
        id: titleText

        height: 65
        anchors { left: frame.right; leftMargin: 5; right: delegate.right; rightMargin: 5; top: frame.top }
        text: title
        color: _TEXT_COLOR
        font.pixelSize: _STANDARD_FONT_SIZE
        font.bold: true
        verticalAlignment: Text.AlignTop
        wrapMode: Text.WordWrap
        clip: true
    }

    Label {
        id: authorText

        anchors { left: frame.right; leftMargin: 5; right: delegate.right; bottom: infoRow.top; bottomMargin: 5 }
        elide: Text.ElideRight
        font.pixelSize: _SMALL_FONT_SIZE
        text: qsTr("By") + " " + author + " " + qsTr("on") + " " + uploadDate.split("T")[0]
        color: "#4d4d4d"
    }

    Row {
        id: infoRow

        anchors { left: titleText.left; bottom: delegate.bottom; bottomMargin: 5 }
        spacing: 10

        Label {
            font.pixelSize: _SMALL_FONT_SIZE
            color: "#4d4d4d"
            text: (views === "") ? 0 : views
        }

        Label {
            font.pixelSize: _SMALL_FONT_SIZE
            color: _TEXT_COLOR
            text: qsTr("views")
        }

        Label {
            font.pixelSize: _SMALL_FONT_SIZE
            color: "#4d4d4d"
            text: (likes == "0") ? "0%" : (likes === "") || (dislikes === "") ? "100%" : Math.floor((parseFloat(likes) / (parseFloat(likes) + parseFloat(dislikes))) * 100) + "%"
        }

        Label {
            font.pixelSize: _SMALL_FONT_SIZE
            color: _TEXT_COLOR
            text: qsTr("like")
        }
    }

    Image {
        id: frame

        z: 1
        width: 162
        height: 122
        anchors { left: delegate.left; top: delegate.top; margins: 5 }
        source: "images/frame.png"
        sourceSize.width: width
        sourceSize.height: height
        smooth: true

        Image {
            id: thumb

            z: -1
            anchors.fill: frame
            source: thumbnail
            smooth: true
            onStatusChanged: if (thumb.status == Image.Error) thumb.source = !theme.inverted ? "images/video.png" : "images/video-white.png";

            Rectangle {
                id: durationLabel

                width: durationText.width + 10
                height: 22
                anchors { bottom: thumb.bottom; right: thumb.right }
                color: "black"
                opacity: 0.5
                smooth: true
                visible: thumb.status == Image.Ready
            }

            Label {
                id: durationText

                anchors.centerIn: durationLabel
                text: DT.getDuration(duration)
                color: "white"
                font.pixelSize: _SMALL_FONT_SIZE
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
                smooth: true
                visible: thumb.status == Image.Ready
            }

            Image {
                width: 30
                height: 30
                anchors.centerIn: thumb
                source: playMouseArea.pressed ? "images/play-button-" + Settings.activeColorString + ".png" : "images/play-button.png"
                sourceSize.width: 30
                sourceSize.height: 30
                smooth: true
                visible: thumb.status == Image.Ready
            }
        }

        MouseArea {
            id: playMouseArea

            z: 1
            anchors.fill: frame
            onClicked: playClicked()
        }
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: parent.clicked()
        onPressAndHold: parent.pressAndHold()
    }
}

