import QtQuick 1.0
import "components"
import "scripts/dailymotion.js" as DM
import "scripts/createobject.js" as ObjectCreator

Dialog {
    id: root

    property string videoId

    signal playVideo(variant video)

    onVideoIdChanged: DM.getVideos("https://api.dailymotion.com/video/" + videoId + "/related?limit=20&family_filter=" + Settings.safeSearch.toString() + "&fields=" + _DM_VIDEO_FIELDS)

    titleText: qsTr("Related videos")
    height: appWindow.height - 100
    destroyOnClosing: true
    content: GridView {
        id: videoList

        anchors.fill: parent
        width: root.width - 20
        height: root.height - titleText.height - 40
        cellWidth: Math.floor(width / 4)
        cellHeight: Math.floor((cellWidth * 3) / 4)
        cacheBuffer: 5000
        maximumFlickVelocity: Settings.maximumFlickVelocity
        flickableDirection: Flickable.VerticalFlick
        clip: true
        model: ListModel {
            id: videoListModel

            property bool loading : true
            property bool error: false
            property bool moreResults: false
            property int page: 1
        }
        delegate: DMRelatedVideoDelegate {
            id: delegate

            width: videoList.cellWidth
            height: videoList.cellHeight
            onClicked: {
                root.playVideo([ObjectCreator.cloneObject(videoListModel.get(index))]);
                root.accept();
            }
        }

        ScrollBar {}

        Label {
            id: noResultsText

            anchors.centerIn: videoList
            font.pixelSize: _LARGE_FONT_SIZE
            font.bold: true
            color: "#4d4d4d"
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            text: qsTr("No related videos")
            visible: (!videoListModel.loading) && (videoListModel.count == 0)
        }

        BusyDialog {
            anchors.centerIn: parent
            visible: videoListModel.loading
        }
    }
}
