import QtQuick 1.0
import "components"
import "scripts/createobject.js" as ObjectCreator
import "scripts/dailymotion.js" as DM

Page {
    id: root

    property bool autoLoad: true
    property string playlistFeed

    function setPlaylistFeed(feed) {
        playlistFeed = feed;
        DM.getPlaylists(playlistFeed);
    }

    function goToPlaylistVideos(playlist) {
        pageStack.push(Qt.resolvedUrl("DMPlaylistVideosPage.qml"));
        pageStack.currentPage.setPlaylist(playlist);
    }

    title: qsTr("Playlists")

    Connections {
        target: playlistModel
        onLoadingChanged: {
            if ((autoLoad) && (!playlistModel.loading) && (playlistModel.moreResults)) {
                DM.getPlaylists(playlistFeed);
            }
        }
    }

    ListView {
        id: playlists

        anchors { fill: parent; topMargin: pageStack.currentPage == root ? titleArea.height : 0 }
        maximumFlickVelocity: Settings.maximumFlickVelocity
        highlightRangeMode: ListView.NoHighlightRange
        clip: true
        onAtYEndChanged: if ((!autoLoad) && (atYEnd) && (!playlistModel.loading) && (playlistModel.moreResults)) DM.getPlaylists(playlistFeed);
        model: ListModel {
            id: playlistModel

            property bool loading: false
            property bool moreResults: false
            property int page: 1
            property bool error: false
        }
        delegate: DMPlaylistDelegate {
            id: delegate

            onClicked: goToPlaylistVideos(ObjectCreator.cloneObject(playlistModel.get(index)))
        }
        footer: Item {
            id: footer

            width: playlists.width
            height: 80
            visible: playlistModel.loading
            opacity: footer.visible ? 1 : 0

            BusyDialog {
                anchors.centerIn: footer
                opacity: footer.opacity
            }
        }

        ScrollBar {}
    }

    Label {
        anchors.centerIn: playlists
        font.pixelSize: _LARGE_FONT_SIZE
        font.bold: true
        color: "#4d4d4d"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("No playlists found")
        visible: (!playlistModel.loading) && (playlistModel.count === 0)
    }
}
