#include "dbusservice.h"
#include <QStringList>
#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusMessage>
#include <QtDBus/QDBusInterface>

DBusService::DBusService(QObject *parent) : QObject(parent), videoToPlay(false) {
}

void DBusService::updateWidgetArchive() {
    QDBusConnection bus = QDBusConnection::sessionBus();
    QDBusInterface dbus_iface("com.marxian.cuteTubeWidget", "/", "com.marxian.cuteTubeWidget", bus);
    dbus_iface.call(QDBus::NoBlock, "updateArchive");
}

void DBusService::setWidgetDownloadPath(const QString &path) {
    QDBusConnection bus = QDBusConnection::sessionBus();
    QDBusInterface dbus_iface("com.marxian.cuteTubeWidget", "/", "com.marxian.cuteTubeWidget", bus);
    dbus_iface.call(QDBus::NoBlock, "setDownloadPath", path);
}

void DBusService::setVideoToPlay(bool play) {
    videoToPlay = play;
    emit videoToPlayChanged();
}

void DBusService::display(const QString &url) {
    parseUrl(url, QString("display"));
}

void DBusService::play(const QString &url) {
    setVideoToPlay(true);
    parseUrl(url, QString("play"));
}

void DBusService::parseUrl(const QString &url, const QString &action) {
    QString videoId;
    if (url.contains(QString("youtu.be"))) {
        videoId = url.split(QString("/")).last();
        if (action == "play") {
            emit playYouTubeVideo(videoId);
        }
        else {
            emit displayYouTubeVideo(videoId);
        }
    }
    else if (url.contains(QString("watch?v="))) {
        videoId = url.split(QString("v=")).at(1).split(QString("&")).first();
        if (action == "play") {
            emit playYouTubeVideo(videoId);
        }
        else {
            emit displayYouTubeVideo(videoId);
        }
    }
    else if (url.contains(QString("dailymotion.com"))) {
        videoId = url.split(QString("/")).last().split(QString("_")).first();
        if (action == "play") {
            emit playDailymotionVideo(videoId);
        }
        else {
            emit displayDailymotionVideo(videoId);
        }
    }
    else {
        emit playArchiveVideo(url);
    }
}
