Qt.include("createobject.js");

var searchOrders = { "published": "recent", "relevance": "relevance", "viewCount": "visited", "rating": "rated" };

function getSearch(query, order) {
    var safe = Settings.safeSearch.toString();
    var videoFeed = "https://api.dailymotion.com/videos?limit=30&family_filter=" + safe + "&fields="
        + _DM_VIDEO_FIELDS + "&sort=" + searchOrders[order];
    var encodedQuery = encodeURIComponent(query.replace(/\s.\s/gi, " "));
    videoFeed += "&search=" + encodedQuery.replace(/\s/g, "+");
    return videoFeed;
}

function getVideo(id, playOrDisplay) {
    toggleBusy(true);
    var request = new XMLHttpRequest();
    request.onreadystatechange = function() {
        if (request.readyState == XMLHttpRequest.DONE) {
            try {
                toggleBusy(false);
                var video = eval("(" + request.responseText + ")");
                video["name"] = video.title;
                video["videoId"] = video.id;
                video["thumbnail"] = video.thumbnail_medium_url;
                video["tags"] = video.tags.toString();
                video["dailymotion"] = true;

                if (playOrDisplay == "play") {
                    playVideos([video]);
                }
                else {
                    pageStack.push(Qt.resolvedUrl("DMInfoPage.qml"));
                    pageStack.currentPage.setVideo(video);
                }
            }
            catch(err) {
                toggleBusy(false);
                messages.displayMessage(qsTr("Cannot retrieve video details"));
            }
        }
    }
    request.open("GET", "https://api.dailymotion.com/video/" + id + "?fields=" + _DM_VIDEO_FIELDS);
    request.send();
}

function getVideos(feed) {
    videoListModel.loading = true;

    var doc = new XMLHttpRequest();
    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.DONE) {
            try {
                var results = eval("(" + doc.responseText + ")");
                if (results.list) {
                    videoListModel.moreResults = results.has_more;
                    var res;
                    for (var i = 0; i < results.list.length; i++) {
                        res = results.list[i];
                        res["name"] = res.title;
                        res["videoId"] = res.id;
                        res["thumbnail"] = res.thumbnail_medium_url;
                        res["tags"] = res.tags.toString();
                        res["dailymotion"] = true;
                        res["isFavourite"] = feed == _DM_FAVOURITES_FEED;
                        videoListModel.append(res);
                    }
                }
                else if (results.error) {
                    console.log(results.error.message);
                    messages.displayMessage(results.error.message);
                }
                videoListModel.page++;
                videoListModel.loading = false;
            }
            catch(err) {
                console.log("error retrieving videos");
                videoListModel.error = true;
                videoListModel.loading = false;
            }
        }
    }
    doc.open("GET", feed + "&page=" + videoListModel.page.toString());
    if (Dailymotion.userSignedIn) {
        doc.setRequestHeader("Authorization", "OAuth " + Dailymotion.accessToken);
    }
    doc.send();
}

function getCurrentUserSubscriptions() {
    dailymotionSubscriptionsModel.loading = true;

    var doc = new XMLHttpRequest();
    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.DONE) {
            try {
                var results = eval("(" + doc.responseText + ")");
                if (results.list) {
                    dailymotionSubscriptionsModel.moreResults = results.has_more;
                    for (var i = 0; i < results.list.length; i++) {
                        dailymotionSubscriptionsModel.append(results.list[i]);
                    }
                }
                else if (results.error) {
                    console.log(results.error.message);
                    messages.displayMessage(results.error.message);
                }
                dailymotionSubscriptionsModel.page++;
                dailymotionSubscriptionsModel.loading = false;
            }
            catch(err) {
                console.log("error retrieving subscriptions");
                dailymotionSubscriptionsModel.error = true;
                dailymotionSubscriptionsModel.loading = false;
            }
        }
    }
    doc.open("GET", _DM_SUBSCRIPTIONS_FEED + "&page=" + dailymotionSubscriptionsModel.page.toString());
    doc.setRequestHeader("Authorization", "OAuth " + Dailymotion.accessToken);
    doc.send();
}

function getCurrentUserGroups() {
    dailymotionGroupModel.loading = true;

    var doc = new XMLHttpRequest();
    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.DONE) {
            try {
                var results = eval("(" + doc.responseText + ")");
                if (results.list) {
                    dailymotionGroupModel.moreResults = results.has_more;
                    var res;
                    for (var i = 0; i < results.list.length; i++) {
                        res = results.list[i];
                        res["owner_username"] = res["owner.username"];
                        res["owner_avatar_medium_url"] = res["owner.avatar_medium_url"];
                        dailymotionGroupModel.append(res);
                    }
                }
                else if (results.error) {
                    console.log(results.error.message);
                    messages.displayMessage(results.error.message);
                }
                dailymotionGroupModel.page++;
                dailymotionGroupModel.loading = false;
            }
            catch(err) {
                console.log("error retrieving groups");
                dailymotionGroupModel.error = true;
                dailymotionGroupModel.loading = false;
            }
        }
    }
    doc.open("GET", _DM_GROUPS_FEED + "&page=" + dailymotionGroupModel.page.toString());
    doc.setRequestHeader("Authorization", "OAuth " + Dailymotion.accessToken);
    doc.send();
}

function getCurrentUserPlaylists() {
    dailymotionPlaylistModel.loading = true;

    var doc = new XMLHttpRequest();
    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.DONE) {
            try {
                var results = eval("(" + doc.responseText + ")");
                if (results.list) {
                    dailymotionPlaylistModel.moreResults = results.has_more;
                    var res;
                    for (var i = 0; i < results.list.length; i++) {
                        res = results.list[i];
                        res["owner_username"] = res["owner.username"];
                        res["owner_avatar_medium_url"] = res["owner.avatar_medium_url"];
                        dailymotionPlaylistModel.append(res);
                    }
                }
                else if (results.error) {
                    console.log(results.error.message);
                    messages.displayMessage(results.error.message);
                }
                dailymotionPlaylistModel.page++;
                dailymotionPlaylistModel.loading = false;
            }
            catch(err) {
                console.log("error retrieving playlists");
                dailymotionPlaylistModel.error = true;
                dailymotionPlaylistModel.loading = false;
            }
        }
    }
    doc.open("GET", _DM_PLAYLISTS_FEED + "&page=" + dailymotionPlaylistModel.page.toString());
    doc.setRequestHeader("Authorization", "OAuth " + Dailymotion.accessToken);
    doc.send();
}

function getSubscriptions(feed) {
    subscriptionsModel.loading = true;

    var doc = new XMLHttpRequest();
    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.DONE) {
            try {
                var results = eval("(" + doc.responseText + ")");
                if (results.list) {
                    subscriptionsModel.moreResults = results.has_more;
                    for (var i = 0; i < results.list.length; i++) {
                        subscriptionsModel.append(results.list[i]);
                    }
                }
                else if (results.error) {
                    console.log(results.error.message);
                    messages.displayMessage(results.error.message);
                }
                subscriptionsModel.page++;
                subscriptionsModel.loading = false;
            }
            catch(err) {
                console.log("error retrieving subscriptions");
                subscriptionsModel.error = true;
                subscriptionsModel.loading = false;
            }
        }
    }
    doc.open("GET", feed + "&page=" + subscriptionsModel.page.toString());
    doc.send();
}

function getPlaylists(feed) {
    playlistModel.loading = true;

    var doc = new XMLHttpRequest();
    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.DONE) {
            try {
                var results = eval("(" + doc.responseText + ")");
                if (results.list) {
                    playlistModel.moreResults = results.has_more;
                    var res;
                    for (var i = 0; i < results.list.length; i++) {
                        res = results.list[i];
                        res["owner_username"] = res["owner.username"];
                        res["owner_avatar_medium_url"] = res["owner.avatar_medium_url"];
                        playlistModel.append(res);
                    }
                }
                else if (results.error) {
                    console.log(results.error.message);
                    messages.displayMessage(results.error.message);
                }
                playlistModel.page++;
                playlistModel.loading = false;
            }
            catch(err) {
                console.log("error retrieving playlists");
                playlistModel.error = true;
                playlistModel.loading = false;
            }
        }
    }
    doc.open("GET", feed + "&page=" + playlistModel.page.toString());
    doc.send();
}

function getGroups(feed) {
    groupModel.loading = true;

    var doc = new XMLHttpRequest();
    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.DONE) {
            try {
                var results = eval("(" + doc.responseText + ")");
                if (results.list) {
                    groupModel.moreResults = results.has_more;
                    var res;
                    for (var i = 0; i < results.list.length; i++) {
                        res = results.list[i];
                        res["owner_username"] = res["owner.username"];
                        res["owner_avatar_medium_url"] = res["owner.avatar_medium_url"];
                        groupModel.append(res);
                    }
                }
                else if (results.error) {
                    console.log(results.error.message);
                    messages.displayMessage(results.error.message);
                }
                groupModel.page++;
                groupModel.loading = false;
            }
            catch(err) {
                console.log("error retrieving groups");
                groupModel.error = true;
                groupModel.loading = false;
            }
        }
    }
    doc.open("GET", feed + "&page=" + groupModel.page.toString());
    doc.send();
}

function getComments(id) {
    commentsModel.loading = true;
    var doc = new XMLHttpRequest();
    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.DONE) {
            try {
                var results = eval("(" + doc.responseText + ")");
                if (results.list) {
                    commentsModel.moreResults = results.has_more;
                    var res;
                    for (var i = 0; i < results.list.length; i++) {
                        res = results.list[i];
                        res["owner_username"] = res["owner.username"];
                        res["owner_avatar_medium_url"] = res["owner.avatar_medium_url"];
                        commentsModel.append(res);
                    }
                }
                else if (results.error) {
                    console.log(results.error.message);
                    messages.displayMessage(results.error.message);
                }
                commentsModel.page++;
                commentsModel.loading = false;
            }
            catch(err) {
                console.log("error retrieving comments");
                commentsModel.error = true;
                commentsModel.loading = false;
            }
        }
    }
    doc.open("GET", "https://api.dailymotion.com/video/" + id + "/comments?fields=id,message,owner,owner.username,owner.avatar_medium_url&page=" + commentsModel.page.toString());
    doc.send();
}

function showPlaylistDialog() {
    var playlistDialog = createObject("DMPlaylistDialog.qml", pageStack);
    playlistDialog.playlistChosen.connect(addVideosToPlaylist);
    playlistDialog.open();
}

function addVideosToPlaylist(playlistId) {
    toggleBusy(true);
    for (var i = 0; i < videoList.checkList.length; i++) {
        Dailymotion.addToPlaylist(videoListModel.get(videoList.checkList[i]).id, playlistId);
    }
    videoList.checkList = [];
}

function deleteVideosFromPlaylist(playlistId) {
    toggleBusy(true);
    for (var i = 0; i < videoList.checkList.length; i++) {
        Dailymotion.deleteFromPlaylist(videoListModel.get(videoList.checkList[i]).id, playlistId);
    }
    videoList.checkList = [];
}

function addVideosToFavourites() {
    toggleBusy(true);
    for (var i = 0; i < videoList.checkList.length; i++) {
        Dailymotion.addToFavourites(videoListModel.get(videoList.checkList[i]).id);
    }
    videoList.checkList = [];
}

function deleteVideosFromFavourites() {
    toggleBusy(true);
    for (var i = 0; i < videoList.checkList.length; i++) {
        Dailymotion.deleteFromFavourites(videoListModel.get(videoList.checkList[i]).id);
    }
    videoList.checkList = [];
}

function addVideosToPlaybackQueue() {
    var list = [];
    for (var i = 0; i < videoList.checkList.length; i++) {
        list.push(cloneObject(videoListModel.get(videoList.checkList[i])));
    }
    playVideos(list);
    videoList.checkList = [];
}

function addVideosToDownloadQueue(convertToAudio) {
    var list = [];
    for (var i = 0; i < videoList.checkList.length; i++) {
        list.push(cloneObject(videoListModel.get(videoList.checkList[i])));
    }
    appendDownloadQueue(list, convertToAudio);
    videoList.checkList = [];
}
