import QtQuick 1.0
import "components"

Page {
    id: root

    title: qsTr("Settings")

    ListView {
        id: settingsList

        anchors { fill: parent; topMargin: titleArea.height }
        clip: true
        maximumFlickVelocity: Settings.maximumFlickVelocity
        model: ListModel {
            id: settingsModel

            ListElement { name: QT_TR_NOOP("Media/Content"); fileName: "WidgetMediaSettingsPage.qml" }
            ListElement { name: QT_TR_NOOP("Appearance"); fileName: "WidgetAppearanceSettingsPage.qml" }
        }

        delegate: DrillDownDelegate {
            id: delegate

            title: name
            onClicked: pageStack.push(Qt.resolvedUrl(fileName))
        }

        ScrollBar {}
    }
}
