import QtQuick 1.0
import "components"

Rectangle {
    id: delegate

    signal clicked(string searchterm)

    width: delegate.ListView.view.width
    height: 40
    color: "white"

    ListHighlight {
        visible: mouseArea.pressed
    }

    Rectangle {
        height: 1
        anchors { top: delegate.top; left: delegate.left; leftMargin: 10; right: delegate.right; rightMargin: 10 }
        color: Qt.lighter(Settings.activeColor, 1.2)
        opacity: 0.5
    }

    Label {
        id: titleText
        elide: Text.ElideRight
        text: searchterm
        color: "black"

        anchors.fill: parent
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: clicked(titleText.text)
    }
}
