import QtQuick 1.0
import "components"

Page {
    id: root

    function goToGroupVideos(group) {
        pageStack.push(Qt.resolvedUrl("DMGroupVideosPage.qml"));
        pageStack.currentPage.title = group.name;
        pageStack.currentPage.setGroup(group.id);
    }

    title: qsTr("My Groups")

    ListView {
        id: groupList

        anchors.fill: parent
        maximumFlickVelocity: Settings.maximumFlickVelocity
        highlightRangeMode: ListView.NoHighlightRange
        clip: true
        model: dailymotionGroupModel
        delegate: DMPlaylistDelegate {
            id: delegate

            onClicked: goToGroupVideos(dailymotionGroupModel.get(index))
        }

        ScrollBar {}
    }

    Label {
        anchors.centerIn: groupList
        font.pixelSize: _LARGE_FONT_SIZE
        font.bold: true
        color: "#4d4d4d"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("No groups found")
        visible: (!dailymotionGroupModel.loading) && (dailymotionGroupModel.count === 0)
    }
}
