import QtQuick 1.0
import QtMultimediaKit 1.1

Item {
    id: root

    property bool pressed

    width: 340
    height: 120

    Rectangle {
        id: background

        anchors.fill: parent
        color: "black"
        radius: 10
    }

    Row {
        anchors.centerIn: parent
        spacing: 10

        Repeater {
            id: repeater

            model: ["stretch", "fit", "crop"]

            Image {
                source: "images/aspect-" + modelData + ".png"
                opacity: children[0].pressed ? 0.5 : videoPlayer.aspectRatio == index ? 1 : 0.7

                MouseArea {
                    anchors.fill: parent
                    onClicked: videoPlayer.aspectRatio = index
                    onPressed: root.pressed = true
                    onReleased: root.pressed = false
                }
            }
        }
    }
}
