#ifndef XTUBE_H
#define XTUBE_H

#include <QObject>
#include <QVariantList>
#include <QNetworkAccessManager>
#include <QNetworkReply>

class XTube : public QObject
{
    Q_OBJECT

    Q_PROPERTY(bool loading
               READ getLoading
               NOTIFY loadingChanged)
public:
    explicit XTube(QObject *parent = 0);

    Q_INVOKABLE void search(QString query);
    Q_INVOKABLE void getMoreVideos();
    Q_INVOKABLE void getYouPornVideoUrl(const QString &url);
    Q_INVOKABLE void getXVideosVideoUrl(const QString &url);
    Q_INVOKABLE void getXHamsterVideoUrl(const QString &url);
    void setNetworkAccessManager(QNetworkAccessManager *manager);
    bool getLoading();

public slots:
    void setQuality(const QString &aQuality);

private slots:
    void parseYouPornPage();
    void parseYouPornVideoPage();
    void parseXVideosPage();
    void parseXVideosVideoPage();
    void parseXHamsterPage();
    void parseXHamsterVideoPage();

private:
    QUrl getYouPornSearchUrl(QString query);
    QUrl getXVideosSearchUrl(QString query);
    QUrl getXHamsterSearchUrl(QString query);
    void getVideos();

signals:
    void gotVideoUrl(const QString &videoUrl);
    void gotVideos(const QVariantList &videos);
    void alert(const QString &message);
    void videoUrlError();
    void loadingChanged();

private:
    QString quality;
    QString searchQuery;
    int pageNumber;
    QNetworkAccessManager *nam;
    QNetworkReply *xvReply;
    QNetworkReply *ypReply;
    QNetworkReply *xhReply;
};

#endif // XTUBE_H
