#ifndef SHARING_H
#define SHARING_H

#include <QObject>
#include <QNetworkAccessManager>

class Sharing : public QObject {
    Q_OBJECT
    Q_PROPERTY(QString facebookId
               READ getFacebookId
               NOTIFY facebookIdChanged)
    Q_PROPERTY(QString twitterId
               READ getTwitterId
               NOTIFY twitterIdChanged)
    Q_PROPERTY(QString twitterSecret
               READ getTwitterSecret
               NOTIFY twitterSecretChanged)
    Q_PROPERTY(bool userSignedInToFacebook
               READ getUserSignedInToFacebook
               NOTIFY userSignedInToFacebookChanged)
    Q_PROPERTY(bool userSignedInToTwitter
               READ getUserSignedInToTwitter
               NOTIFY userSignedInToTwitterChanged)
    Q_PROPERTY(QString twitterToken
               READ getTwitterToken
               NOTIFY twitterTokenChanged)
    Q_PROPERTY(QString twitterTokenSecret
               READ getTwitterTokenSecret
               NOTIFY twitterTokenSecretChanged)

public:
    explicit Sharing(QObject *parent = 0);

    void setNetworkAccessManager(QNetworkAccessManager *manager);
    QString getFacebookId() const { return facebookId; }
    QString getTwitterId() const { return twitterId; }
    QString getTwitterSecret() const { return twitterSecret; }
    QString getTwitterToken() const { return twitterToken; }
    QString getTwitterTokenSecret() const { return twitterTokenSecret; }
    bool getUserSignedInToFacebook() { return !facebookToken.isEmpty(); }
    bool getUserSignedInToTwitter() { return (!twitterToken.isEmpty()) && (!twitterTokenSecret.isEmpty()); }
    Q_INVOKABLE void postToFacebook(const QString &site, const QString &videoId, const QString &title, const QString &description, const QString &message, const QString &thumb);
    Q_INVOKABLE void postToTwitter(const QString &url, const QString &header, const QString &body);
    Q_INVOKABLE void copyToClipboard(const QString &url);

public slots:
    void setFacebookAccessToken(const QString &token);
    void setTwitterAccount(const QString &token, const QString &secret);


private slots:
    void postFinished();

private:
    QNetworkAccessManager *nam;
    QString facebookId;
    QString facebookToken;
    QString twitterId;
    QString twitterToken;
    QString twitterSecret;
    QString twitterTokenSecret;

signals:
    void alert(const QString &message);
    void facebookIdChanged();
    void userSignedInToFacebookChanged();
    void twitterIdChanged();
    void twitterSecretChanged();
    void twitterTokenChanged();
    void twitterTokenSecretChanged();
    void userSignedInToTwitterChanged();
    void postSuccessful();
    void postedToFacebook();
    void postedToTwitter();
};

#endif // SHARING_H
