import QtQuick 1.0
import "components"

QueryDialog {
    id: root

    property variant video: []

    function shareToFacebook() {
        toggleBusy(true);
        var site = video.youtube ? "youtube" : "dailymotion";
        var thumbnail = video.youtube ? video.largeThumbnail : video.thumbnail_large_url;
        Sharing.postToFacebook(site, video.videoId, titleInput.text, descriptionInput.text, messageInput.text, thumbnail);
    }

    titleText: qsTr("Share to facebook")
    acceptButtonText: titleInput.text == "" ? "" : qsTr("Share")
    rejectButtonText: qsTr("Cancel")
    onAccepted: shareToFacebook()
    content: Flickable {
        id: flicker

        anchors.fill: parent
        contentWidth: parent.width
        contentHeight: col1.height + 20
        flickableDirection: Flickable.VerticalFlick
        clip: true

        Column {
            id: col1

            z: 101
            anchors { top: parent.top; left: parent.left; right: parent.right; margins: 10 }
            spacing: 20

            Label {
                font.bold: true
                
                text: qsTr("Title")
            }

            TextField {
                id: titleInput

                width: parent.width
                text: !video.title ? "" : video.title
            }

            Label {
                font.bold: true
                
                text: qsTr("Description")
            }

            TextArea {
                id: descriptionInput

                width: parent.width
                text: !video.description ? "" : video.description
            }

            Label {
                font.bold: true
                
                text: qsTr("Message")
            }

            TextArea {
                id: messageInput

                width: parent.width
            }
        }
    }
}
