#ifndef DBUSSERVICE_H
#define DBUSSERVICE_H

#include <QObject>

class DBusService : public QObject {
    Q_OBJECT
    Q_PROPERTY(bool videoToPlay
               READ getVideoToPlay
               NOTIFY videoToPlayChanged)
public:
    explicit DBusService(QObject *parent = 0);
    bool getVideoToPlay() { return videoToPlay; }

public Q_SLOTS:
    void play(const QString &url);
    void display(const QString &url);
    void setWidgetDownloadPath(const QString &path);
    void updateWidgetArchive();

private:
    void parseUrl(const QString &url, const QString &action);
    void setVideoToPlay(bool play);
    bool videoToPlay;

signals:
    void playYouTubeVideo(const QString &videoId);
    void displayYouTubeVideo(const QString &videoId);
    void playDailymotionVideo(const QString &videoId);
    void displayDailymotionVideo(const QString &videoId);
    void playArchiveVideo(const QString &url);
    void videoToPlayChanged();
};

#endif // DBUSSERVICE_H
