#ifndef YouTube_H
#define YouTube_H

#include <QObject>
#include <QByteArray>
#include <QtNetwork/QNetworkAccessManager>
#include <QUrl>
#include <QFile>
#include <QTime>
#include <QVariantMap>
#include <QClipboard>

class QNetworkAccessManager;
class QNetworkReply;

class YouTube : public QObject {
    Q_OBJECT
    Q_PROPERTY(QString username
               READ getUsername
               NOTIFY usernameChanged)
    Q_PROPERTY(QString accessToken
               READ getAccessToken
               NOTIFY accessTokenChanged)
    Q_PROPERTY(bool userSignedIn
               READ getUserSignedIn
               NOTIFY userSignedInChanged)

public:
    explicit YouTube(QObject *parent = 0);
    virtual ~YouTube();
    QString getUsername() const { return username; }
    QString getAccessToken() const { return accessToken; }
    bool getUserSignedIn() const { return !accessToken.isEmpty(); }

public slots:
    QString getDeveloperKey() const { return QString(developerKey); }
    void setUsername(const QString &user);
    void setAccessToken(const QString &token);
    void getVideoUrl(const QString &videoId);


private slots:
    void parseVideoPage(QNetworkReply *reply);

private:
    QByteArray developerKey;
    QString username;
    QString accessToken;
    int playbackFormat;
    QHash<QString, int> pbMap;

signals:
    void gotVideoUrl(const QString &videoUrl);
    void videoUrlError();
    void alert(const QString &message);
    void usernameChanged();
    void accessTokenChanged();
    void userSignedInChanged();
};

#endif // YouTube_H
