#include "utils.h"
#include <QFile>
#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusMessage>
#include <QtDBus/QDBusInterface>
#include <QProcess>

Utils::Utils(QObject *parent) :
    QObject(parent) {
}

void Utils::setMediaPlayer(const QString &player) {
    mediaPlayer = player.toLower().replace(" ", "");
}

QVariantList Utils::getInstalledMediaPlayers() const {
    QVariantList playerList;
    QVariantMap player;

    if ((QFile::exists("/usr/bin/mplayer"))) {
        player.insert("name", tr("MPlayer"));
        player.insert("value", "mplayer");
        playerList.append(player);
    }
    if ((QFile::exists("/opt/kmplayer/bin/kmplayer")) || (QFile::exists("/usr/bin/kmplayer"))) {
        player.insert("name", tr("KMPlayer"));
        player.insert("value", "kmplayer");
        playerList.append(player);
    }
    return playerList;
}

void Utils::displayVideo(const QString &url) {
    QDBusConnection bus = QDBusConnection::sessionBus();
    QDBusInterface dbus_iface("com.marxian.cuteTube", "/", "com.marxian.cuteTube", bus);
    dbus_iface.call(QDBus::NoBlock, "display", url);
}

void Utils::playVideo(const QString &url) {
    if (mediaPlayer == "cutetubeplayer") {
        QDBusConnection bus = QDBusConnection::sessionBus();
        QDBusInterface dbus_iface("com.marxian.cuteTube", "/", "com.marxian.cuteTube", bus);
        dbus_iface.call(QDBus::NoBlock, "play", url);
    }
    else if (mediaPlayer == "mplayer") {
        QStringList args;
        args << "-cache" << "4096" << "-fs" << url;
        QProcess *player = new QProcess();
        connect(player, SIGNAL(finished(int, QProcess::ExitStatus)), player, SLOT(deleteLater()));
        player->start("/usr/bin/mplayer", args);
    }
    else {
        QDBusConnection bus = QDBusConnection::sessionBus();
        QDBusInterface dbus_iface("com.nokia." + mediaPlayer, "/com/nokia/" + mediaPlayer, "com.nokia." + mediaPlayer, bus);
        dbus_iface.call(QDBus::NoBlock, "mime_open", url);
    }
}

void Utils::showSettings() {
    QProcess *settings = new QProcess();
    connect(settings, SIGNAL(finished(int, QProcess::ExitStatus)), settings, SLOT(deleteLater()));
    settings->start("/opt/qmltube/bin/qmltube-widget-settings");
}
