#ifndef SETTINGS_H
#define SETTINGS_H

#include "qmlapplicationviewer.h"
#include <QSettings>
#include <QStringList>

class Settings : public QSettings
{
    Q_OBJECT

    Q_PROPERTY(QString youtubeWidgetFeed
               READ getYouTubeWidgetFeed
               NOTIFY youtubeWidgetFeedChanged)
    Q_PROPERTY(QString dailymotionWidgetFeed
               READ getDailymotionWidgetFeed
               NOTIFY dailymotionWidgetFeedChanged)
    Q_PROPERTY(QString searchQuery
               READ getSearchQuery
               NOTIFY searchQueryChanged)
    Q_PROPERTY(bool safeSearch
               READ getSafeSearch
               NOTIFY safeSearchChanged)
    Q_PROPERTY(QString searchOrder
               READ getSearchOrder
               NOTIFY searchOrderChanged)
    Q_PROPERTY(QString durationFilter
               READ getDurationFilter
               NOTIFY durationFilterChanged)
    Q_PROPERTY(QString appTheme
               READ getTheme
               NOTIFY themeChanged)
    Q_PROPERTY(QString activeColor
               READ getActiveColor
               NOTIFY activeColorChanged)
    Q_PROPERTY(QString activeColorString
               READ getActiveColorString
               NOTIFY activeColorStringChanged)
    Q_PROPERTY(QString gradientColor
               READ getGradientColor
               NOTIFY gradientColorChanged)
    Q_PROPERTY(QString gradientColorHigh
               READ getGradientColorHigh
               NOTIFY gradientColorHighChanged)
    Q_PROPERTY(QString mediaPlayer
               READ getMediaPlayer
               NOTIFY mediaPlayerChanged)
    Q_PROPERTY(QString downloadPath
               READ getDownloadPath
               WRITE setDownloadPath
               NOTIFY downloadPathChanged)

public:
    explicit Settings(QSettings *parent = 0);
    virtual ~Settings();
    QString getYouTubeWidgetFeed() const { return youtubeWidgetFeed; }
    QString getDailymotionWidgetFeed() const { return dailymotionWidgetFeed; }
    QString getSearchQuery() const { return searchQuery; }
    bool getSafeSearch() { return safeSearch; }
    QString getSearchOrder() const { return searchOrder; }
    QString getDurationFilter() const { return durationFilter; }
    QString getTheme() const { return theme; }
    QString getActiveColor() const { return activeColor; }
    QString getActiveColorString() const { return activeColorString; }
    QString getGradientColor() const { return gradientColor; }
    QString getGradientColorHigh() const { return gradientColorHigh; }
    QString getMediaPlayer() const { return mediaPlayer; }
    QString getLanguage() const { return language; }
    QString getDownloadPath() const { return downloadPath; }
    void restoreSettings();

signals:
    void refreshWidget();
    void archiveUpdated();
    void youtubeWidgetFeedChanged();
    void dailymotionWidgetFeedChanged();
    void searchQueryChanged();
    void safeSearchChanged();
    void searchOrderChanged();
    void durationFilterChanged();
    void themeChanged();
    void activeColorChanged();
    void activeColorStringChanged();
    void gradientColorChanged();
    void gradientColorHighChanged();
    void alert(const QString &message);
    void mediaPlayerChanged(const QString &player);
    void youtubeUsernameChanged(const QString &user);
    void youtubeAccessTokenChanged(const QString &token);
    void dailymotionAccountChanged(const QString &user, const QString &aToken, const QString &rToken, int tokenExpiry);
    void downloadPathChanged();

public slots:
    void setDailymotionAccount(const QString &user, const QString &aToken, const QString &rToken, int tokenExpiry);
    void setYouTubeWidgetFeed(const QString &feed);
    void setDailymotionWidgetFeed(const QString &feed);
    void setSearchQuery(const QString &query);
    void setSafeSearch(bool safe);
    void setSearchOrder(const QString &order);
    void setDurationFilter(const QString &filter);
    void setTheme(const QString &aTheme);
    void setActiveColor(const QString &color);
    void setActiveColorString(const QString &colorString);
    void setMediaPlayer(const QString &player);
    void setDownloadPath(const QString &path);
    void updateArchive();
    void refresh();

private:
    void setGradientColor(const QString &color);
    void setGradientColorHigh(const QString &color);
    void setYouTubeUsername(const QString &user);
    void setYouTubeAccessToken(const QString &token);
    void setLanguage(const QString &lang);

private:
    bool safeSearch;
    QString youtubeWidgetFeed;
    QString dailymotionWidgetFeed;
    QString searchQuery;
    QString searchOrder;
    QString durationFilter;
    QString theme;
    QString language;
    QString activeColor;
    QString activeColorString;
    QString gradientColor;
    QString gradientColorHigh;
    QString mediaPlayer;
    QString youtubeUsername;
    QString youtubeAccessToken;
    QString dailymotionAccessToken;
    QString dailymotionRefreshToken;
    QString dailymotionUsername;
    QString downloadPath;
};

#endif // SETTINGS_H
