#include "utils.h"
#include <QFile>
#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusMessage>
#include <QtDBus/QDBusInterface>
#include <QTimer>
#include <QTime>

Utils::Utils(QObject *parent) :
    QObject(parent), viewer(0) {

    QTimer *timer = new QTimer(this);
    timer->setSingleShot(false);
    timer->setInterval(30000);
    connect(timer, SIGNAL(timeout()), this, SIGNAL(currentTimeChanged()));
    timer->start();
    emit currentTimeChanged();
}

void Utils::setView(QmlApplicationViewer *view) {
    viewer = view;
}

QString Utils::getCurrentTime() const {
    return QTime::currentTime().toString("h:mm ap");
}

void Utils::minimize() {
    QDBusConnection bus = QDBusConnection::sessionBus();

    QDBusMessage message = QDBusMessage::createSignal("/", "com.nokia.hildon_desktop", "exit_app_view");
    if (bus.send(message)) {
        emit windowMinimized();
    }
}

QVariantList Utils::getInstalledMediaPlayers() const {
    QVariantList playerList;
    QVariantMap player;

    if ((QFile::exists("/usr/bin/mplayer"))) {
        player.insert("name", tr("MPlayer"));
        player.insert("value", "mplayer");
        playerList.append(player);
    }
    if ((QFile::exists("/opt/kmplayer/bin/kmplayer")) || (QFile::exists("/usr/bin/kmplayer"))) {
        player.insert("name", tr("KMPlayer"));
        player.insert("value", "kmplayer");
        playerList.append(player);
    }
    return playerList;
}
