import QtQuick 1.0
import "components"
import "scripts/dateandtime.js" as DT

Item {
    id: root

    signal clicked
    signal pressAndHold
    signal playClicked

    width: parent.width
    height: 83

    ListHighlight {
        visible: mouseArea.pressed
    }

    Label {
        id: titleText

        height: 50
        anchors { left: frame.right; leftMargin: 5; right: root.right; rightMargin: 5; top: frame.top }
        wrapMode: Text.WordWrap
        
        text: title
        
        font.bold: true
        verticalAlignment: Text.AlignTop
        clip: true
    }

    Row {
        id: infoRow

        anchors { left: titleText.left; bottom: frame.bottom }
        spacing: 10

        Label {
            font.pixelSize: _SMALL_FONT_SIZE
            color: "#4d4d4d"
            text: (views === "") ? 0 : views
        }

        Label {
            font.pixelSize: _SMALL_FONT_SIZE
            
            text: qsTr("views")
        }

        Label {
            font.pixelSize: _SMALL_FONT_SIZE
            color: "#4d4d4d"
            text: (likes == "0") ? "0%" : (likes === "") || (dislikes === "") ? "100%" : Math.floor((parseFloat(likes) / (parseFloat(likes) + parseFloat(dislikes))) * 100) + "%"
        }

        Label {
            font.pixelSize: _SMALL_FONT_SIZE
            
            text: qsTr("like")
        }
    }

    Image {
        id: frame

        z: 1
        width: 102
        height: 77
        anchors { left: root.left; leftMargin: 5; verticalCenter: root.verticalCenter }
        source: "images/frame.png"
        sourceSize.width: width
        sourceSize.height: height
        smooth: true

        Image {
            id: thumb

            z: -1
            anchors.fill: frame
            source: thumbnail
            smooth: true
            onStatusChanged: if (thumb.status == Image.Error) thumb.source = Settings.appTheme == "light" ? "images/video.png" : "images/video-white.png";

            Rectangle {
                id: durationLabel

                width: durationText.width + 10
                height: 16
                anchors { bottom: thumb.bottom; right: thumb.right }
                color: "black"
                opacity: 0.5
                smooth: true
                visible: thumb.status == Image.Ready
            }

            Label {
                id: durationText

                anchors.centerIn: durationLabel
                text: DT.getDuration(duration)
                color: "white"
                font.pixelSize: _SMALL_FONT_SIZE
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
                smooth: true
                visible: thumb.status == Image.Ready
            }

            Image {
                width: 20
                height: 20
                anchors.centerIn: thumb
                source: playMouseArea.pressed ? "images/play-button-" + Settings.activeColorString + ".png" : "images/play-button.png"
                sourceSize.width: width
                sourceSize.height: height
                smooth: true
                visible: thumb.status == Image.Ready
            }
        }

        MouseArea {
            id: playMouseArea

            z: 1
            anchors.fill: frame
            onClicked: playClicked()
            onPressAndHold: root.pressAndHold()
        }
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: parent.clicked()
        onPressAndHold: parent.pressAndHold()
    }
}

