import QtQuick 1.0
import "components"

Page {
    id: root

    title: qsTr("Settings")

    ListView {
        id: settingsList

        anchors { fill: parent; topMargin: titleArea.height }
        clip: true
        boundsBehavior: Flickable.DragOverBounds
        model: ListModel {
            id: settingsModel

            ListElement { name: QT_TR_NOOP("Media/Content"); fileName: "MediaSettingsPage.qml" }
            ListElement { name: QT_TR_NOOP("Search"); fileName: "SearchSettingsPage.qml" }
            ListElement { name: QT_TR_NOOP("Transfers"); fileName: "TransferSettingsPage.qml" }
            ListElement { name: QT_TR_NOOP("Appearance"); fileName: "AppearanceSettingsPage.qml" }
            ListElement { name: QT_TR_NOOP("Other"); fileName: "SystemSettingsPage.qml" }
        }

        delegate: DrillDownDelegate {
            id: delegate

            title: name
            onClicked: pageStack.push(Qt.resolvedUrl(fileName))
        }

        ScrollBar {}
    }    
}
