#include "dbusservice.h"
#include <QStringList>

DBusService::DBusService(QObject *parent) : QObject(parent) {
}

void DBusService::display(const QString &url) {
    parseUrl(url, QString("display"));
}

void DBusService::play(const QString &url) {
    parseUrl(url, QString("play"));
}

void DBusService::parseUrl(const QString &url, const QString &action) {
    QString videoId;
    if (url.contains(QString("youtu.be"))) {
        videoId = url.split(QString("/")).last();
        if (action == "play") {
            emit playYouTubeVideo(videoId);
        }
        else {
            emit displayYouTubeVideo(videoId);
        }
    }
    else if (url.contains(QString("watch?v="))) {
        videoId = url.split(QString("v=")).at(1).split(QString("&")).first();
        if (action == "play") {
            emit playYouTubeVideo(videoId);
        }
        else {
            emit displayYouTubeVideo(videoId);
        }
    }
    else if (url.contains(QString("dailymotion.com"))) {
        videoId = url.split(QString("/")).last().split(QString("_")).first();
        if (action == "play") {
            emit playDailymotionVideo(videoId);
        }
        else {
            emit displayDailymotionVideo(videoId);
        }
    }
}
