import QtQuick 1.0

Item {
    id: root

    property bool useTheme: true
    property bool enabled: true
    property alias placeholderText: searchInput.placeholderText
    property alias text: searchInput.text
    property alias buttonIconSource: searchInput.buttonIconSource

    signal search(string query)

    width: appWindow.inPortrait ? parent.width : Math.floor(parent.width / 2) - 5
    height: 70
    opacity: enabled ? 1 : 0.3

    Rectangle {
        id: background

        anchors.fill: parent
        radius: 10
        gradient: Gradient {
            GradientStop { id: gradient1; position: 0.0; color: root.useTheme ? Settings.gradientColorHigh : "#524e4e" }
            GradientStop { id: gradient2; position: 0.7; color: root.useTheme ? Settings.gradientColor : "black"}
        }
        border.width: 2
        border.color: Settings.activeColor
        opacity: 0.7
        smooth: true
    }

    TextField {
        id: searchInput

        anchors { fill: parent; margins: 10 }
        buttonIconSource: "../images/search.png"
        buttonMargin: 50
        onButtonClicked: search(searchInput.text)
        Keys.onEnterPressed: search(searchInput.text)
        Keys.onReturnPressed: search(searchInput.text)
    }

    onSearch: pageStack.currentPage.tools.close();
}



