import QtQuick 1.0
import "components"
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    function showFileBrowserDialog() {
        var browser = ObjectCreator.createObject(Qt.resolvedUrl("FileBrowserDialog.qml"), pageStack);
        browser.titleText = qsTr("Archive folder");
        browser.open();
    }

    title: qsTr("Settings") + " - " + qsTr("Media") + "/" + qsTr("Content")

    Flickable {
        id: flicker

        anchors { fill: parent; topMargin: titleArea.height }
        contentWidth: parent.width
        contentHeight: col1.height
        flickableDirection: Flickable.VerticalFlick
        clip: true

        Column {
            id: col1

            anchors { top: parent.top; left: parent.left; right: parent.right }
            spacing: 20

            SelectionItem {
                title: qsTr("Default site")
                model: ListModel {
                    ListElement { name: QT_TR_NOOP("YouTube"); value: "youtube" }
                    ListElement { name: QT_TR_NOOP("Dailymotion"); value: "dailymotion" }
                }
                initialValue: Settings.defaultSite
                onValueChosen: Settings.defaultSite = value
            }

            SelectionItem {
                title: qsTr("Media player")
                model: ListModel {
                    ListElement { name: QT_TR_NOOP("cuteTube Player"); value: "cutetubePlayer" }
                    ListElement { name: QT_TR_NOOP("Media Player"); value: "mediaplayer" }
                }
                onValueChosen: Settings.mediaPlayer = value

                Component.onCompleted: {
                    var mediaPlayers = Utils.getInstalledMediaPlayers();
                    for (var i = 0; i < mediaPlayers.length; i++) {
                        model.append(mediaPlayers[i]);
                    }
                    setInitialValue(Settings.mediaPlayer);
                }
            }

            SelectionItem {
                title: qsTr("Download quality")
                model: ListModel {
                    ListElement { name: QT_TR_NOOP("Normal (upto 360p)"); value: "hq" }
                    ListElement { name: QT_TR_NOOP("480p"); value: "480p" }
                    ListElement { name: QT_TR_NOOP("720p"); value: "720p" }
                    ListElement { name: QT_TR_NOOP("1080p"); value: "1080p" }
                }
                initialValue: Settings.youtubeDownloadQuality
                onValueChosen: Settings.youtubeDownloadQuality = value
            }

            SelectionItemBasic {
                title: qsTr("Archive folder")
                subTitle: Settings.downloadPath
                onClicked: showFileBrowserDialog()
            }            
        }
    }
}
