import QtQuick 1.0

Item {
    id: root

    property bool checked: false

    width: 100
    height: 50

    Rectangle {
        id: border

        anchors.fill: parent
        color: _BACKGROUND_COLOR
        border.width: 2
        border.color: Settings.activeColor
        radius: 5
        opacity: 0.5
    }

    Button {
        id: button

        width: 50
        anchors { left: root.left; top: root.top; bottom: root.bottom }
        checked: true
    }

    Text {
        id: label

        anchors { left: border.right; leftMargin: 10; verticalCenter: root.verticalCenter }
        font.pixelSize: _STANDARD_FONT_SIZE
        color: _TEXT_COLOR
        verticalAlignment: Text.AlignVCenter
    }

    MouseArea {
        id: mouseArea

        anchors.fill: root
        onClicked: checked = !checked
    }

    states: State {
        name: "checked"
        when: checked
        AnchorChanges { target: button; anchors { left: undefined; right: root.right } }
    }

    transitions: Transition {
        AnchorAnimation { easing.type: Easing.OutQuart; duration: 300 }
    }
}

