import QtQuick 1.0
import "components"
import "scripts/OAuth.js" as OAuth

QueryDialog {
    id: root

    property variant video: []

    function shareToTwitter() {
        toggleBusy(true);
        var credentials = { "token": Sharing.twitterToken, "secret": Sharing.twitterTokenSecret };
        var body = "status=" + OAuth.url_encode(messageInput.text);
        var oauthData = OAuth.createOAuthHeader("POST", "http://api.twitter.com/1/statuses/update.xml", credentials, undefined, undefined, body);
        Sharing.postToTwitter(oauthData.url, oauthData.header, body);
    }

    titleText: qsTr("Share to twitter")
    acceptButtonText: (messageInput.text == "") || (messageInput.text.length > 140) ? "" : qsTr("Share")
    rejectButtonText: qsTr("Cancel")
    onAccepted: shareToTwitter()
    content: Flickable {
        id: flicker

        anchors.fill: parent
        contentWidth: parent.width
        contentHeight: col1.height + 20
        flickableDirection: Flickable.VerticalFlick
        clip: true

        Column {
            id: col1

            anchors { top: parent.top; left: parent.left; right: parent.right; margins: 10 }
            spacing: 20

            Row {
                x: 10
                spacing: parent.width - (children[0].width + children[1].width + 20)

                Text {
                    font.bold: true
                    color: _TEXT_COLOR
                    text: qsTr("Message")
                }

                Text {
                    color: messageInput.text.length > 140 ? "red" : _TEXT_COLOR
                    text: 140 - messageInput.text.length
                    horizontalAlignment: Text.AlignRight
                }
            }

            TextArea {
                id: messageInput

                width: parent.width
                text: !video.videoId ? "" : video.youtube ? "http://youtu.be/" + video.videoId : video.url
            }
        }
    }
}
