import QtQuick 1.0
import "components"
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    function goToNewSubVideos() {
        pageStack.push(Qt.resolvedUrl("YTListPage.qml"));
        pageStack.currentPage.setVideoFeed(_NEW_SUB_VIDEOS_FEED);
        pageStack.currentPage.title = qsTr("New Subscription Videos");
    }

    function goToUserProfile(user) {
        pageStack.push(Qt.resolvedUrl("YTUserPage.qml"));
        pageStack.currentPage.getUserProfile(user);
    }

    title: qsTr("My Subscriptions")
    tools: Menu {

        menuItems: MenuItem {
            text: qsTr("New subscription videos")
            onClicked: goToNewSubVideos()
        }
    }

    ListView {
        id: subscriptionsList

        anchors.fill: parent
        boundsBehavior: Flickable.DragOverBounds
        highlightRangeMode: ListView.StrictlyEnforceRange
        clip: true
        model: youtubeSubscriptionsModel
        delegate: YTSubscriptionDelegate {
            id: delegate

            onClicked: goToUserProfile(title)
        }

        ScrollBar {}
    }

    Text {
        anchors.centerIn: subscriptionsList
        font.pixelSize: _LARGE_FONT_SIZE
        font.bold: true
        color: "#4d4d4d"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("No subscriptions found")
        visible: (!youtubeSubscriptionsModel.loading) && (youtubeSubscriptionsModel.count === 0)
    }
}
