import QtQuick 1.0
import "components"
import "scripts/dateandtime.js" as DT

Item {
    id: delegate

    property bool checked

    signal clicked
    signal pressAndHold
    signal playClicked

    width: parent.width
    height: 100

    ListHighlight {
        visible: (mouseArea.pressed) || (delegate.checked)
    }

    Text {
        id: titleText

        anchors { left: frame.right; leftMargin: 5; right: delegate.right; rightMargin: 5; top: frame.top }
        elide: Text.ElideRight
        text: title
        color: _TEXT_COLOR
        font.bold: true
        textFormat: Text.StyledText
        verticalAlignment: Text.AlignTop
    }

    Row {
        id: infoRow

        anchors { left: titleText.left; bottom: frame.bottom }
        spacing: 10

        RatingIndicator {
            maximumValue: 5
            ratingValue: rating
            count: 0
        }

        Text {
            font.pixelSize: _SMALL_FONT_SIZE
            color: "#4d4d4d"
            text: viewCount
            visible: viewCount > 0
        }

        Text {
            font.pixelSize: _SMALL_FONT_SIZE
            color: _TEXT_COLOR
            text: qsTr("views")
            visible: viewCount > 0
        }
    }

    Image {
        id: frame

        z: 1
        width: 122
        height: 92
        anchors { left: delegate.left; leftMargin: 5; verticalCenter: delegate.verticalCenter }
        source: "images/frame.png"
        sourceSize.width: width
        sourceSize.height: height
        smooth: true

        Image {
            id: thumb

            z: -1
            anchors.fill: frame
            source: thumbnail
            smooth: true
            onStatusChanged: if (thumb.status == Image.Error) thumb.source = Settings.appTheme == "light" ? "images/video.png" : "images/video-white.png";

            Rectangle {
                id: durationLabel

                width: durationText.width + 10
                height: 22
                anchors { bottom: thumb.bottom; right: thumb.right }
                color: "black"
                opacity: 0.5
                smooth: true
                visible: thumb.status == Image.Ready
            }

            Text {
                id: durationText

                anchors.centerIn: durationLabel
                text: duration
                color: "white"
                font.pixelSize: _SMALL_FONT_SIZE
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
                smooth: true
                visible: thumb.status == Image.Ready
            }

            Image {
                width: 30
                height: 30
                anchors.centerIn: thumb
                source: playMouseArea.pressed ? "images/play-button-" + Settings.activeColorString + ".png" : "images/play-button.png"
                sourceSize.width: 30
                sourceSize.height: 30
                smooth: true
                visible: thumb.status == Image.Ready
            }
        }

        MouseArea {
            id: playMouseArea

            z: 1
            anchors.fill: frame
            onClicked: playClicked()
        }
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: parent.clicked()
        onPressAndHold: parent.pressAndHold()
    }
}

