Qt.include("createobject.js");

function getYouTubeSearch(query, order) {
    var encodedQuery = encodeURIComponent(query.replace(/\s.\s/gi, " "));
    var safe = Settings.safeSearch ? "strict" : "none";
    var videoFeed = "http://gdata.youtube.com/feeds/api/videos?v=2&max-results=30&safeSearch=" + safe + "&q=%22"
        + encodedQuery + "%22%7C" + encodedQuery.replace(/\s/g, "+") + "&orderby=" + order + "&alt=json";
    return videoFeed;
}

function getYouTubePlaylistSearch(query) {
    var encodedQuery = encodeURIComponent(query.replace(/\s.\s/gi, " "));
    var safe = Settings.safeSearch ? "strict" : "none";
    var playlistFeed = "http://gdata.youtube.com/feeds/api/playlists/snippets?v=2&max-results=30&safeSearch=" + safe + "&q=%22"
        + encodedQuery + "%22%7C" + encodedQuery.replace(/\s/g, "+") + "&alt=json";
    return playlistFeed;
}

function getVideoFromClipboard(id) {
    var request = new XMLHttpRequest();
    request.onreadystatechange = function() {
        if (request.readyState == XMLHttpRequest.DONE) {
            try {
                var res = eval("(" + request.responseText + ")").entry;
                if ((res.app$control) && (res.app$control.yt$state) && (res.app$control.yt$state.reasonCode != "limitedSyndication")) {
                    messages.displayMessage(qsTr("Video is not available"));
                }
                else {
                    var video = { "playerUrl": "http://youtube.com/watch?v=" + res.media$group.yt$videoid.$t, "id": res.id.$t,
                        "videoId": res.media$group.yt$videoid.$t, "title": res.title.$t, "name": res.title.$t,
                        "description": res.media$group.media$description.$t, "author": res.media$group.media$credit[0].$t,
                        "likes": res.yt$rating ? res.yt$rating.numLikes : "0", "dislikes": res.yt$rating ? res.yt$rating.numDislikes : "0",
                        "views": res.yt$statistics ? res.yt$statistics.viewCount : "0", "duration": res.media$group.yt$duration.seconds,
                        "tags": res.media$group.media$keywords.$t, "uploadDate": res.media$group.yt$uploaded.$t,
                        "thumbnail": res.media$group.media$thumbnail[0].url, "comments": res.gd$comments ? res.gd$comments.gd$feedLink.countHint : "0",
                        "largeThumbnail": res.media$group.media$thumbnail[1].url, "youtube": true };

                    if (Settings.playClipboardVideos) {
                        appendPlaybackQueue([video]);
                    }
                    if (Settings.downloadClipboardVideos) {
                        appendDownloadQueue([video], false);
                    }
                }
            }
            catch(err) {
                toggleBusy(false);
                messages.displayMessage(qsTr("Cannot retrieve video details"));
                console.log("Cannot retrieve video");
            }
        }
    }
    request.open("GET", "http://gdata.youtube.com/feeds/api/videos/" + id + "?v=2&alt=json");
    request.send();
}

function getVideosFromIds(ids) {
    for (var i = 0; i < ids.length; i++) {
        getVideoFromClipboard(ids[i]);
    }
}

function getYouTubeVideo(id) {
    toggleBusy(true);
    var request = new XMLHttpRequest();
    request.onreadystatechange = function() {
        if (request.readyState == XMLHttpRequest.DONE) {
            try {
                var res = eval("(" + request.responseText + ")").entry;
                if ((res.app$control) && (res.app$control.yt$state) && (res.app$control.yt$state.reasonCode != "limitedSyndication")) {
                    messages.displayMessage(qsTr("Video is not available"));
                }
                else {
                    var video = { "playerUrl": "http://youtube.com/watch?v=" + res.media$group.yt$videoid.$t, "id": res.id.$t,
                        "videoId": res.media$group.yt$videoid.$t, "title": res.title.$t,
                        "description": res.media$group.media$description.$t, "author": res.media$group.media$credit[0].$t,
                        "likes": res.yt$rating ? res.yt$rating.numLikes : "0", "dislikes": res.yt$rating ? res.yt$rating.numDislikes : "0",
                        "views": res.yt$statistics ? res.yt$statistics.viewCount : "0", "duration": res.media$group.yt$duration.seconds,
                        "tags": res.media$group.media$keywords.$t, "uploadDate": res.media$group.yt$uploaded.$t,
                        "thumbnail": res.media$group.media$thumbnail[0].url, "comments": res.gd$comments ? res.gd$comments.gd$feedLink.countHint : "0",
                        "largeThumbnail": res.media$group.media$thumbnail[1].url, "youtube": true };

                    toggleBusy(false);
                    pageStack.push(Qt.resolvedUrl("YTInfoPage.qml"));
                    pageStack.currentPage.setVideo(video);
                }
            }
            catch(err) {
                toggleBusy(false);
                messages.displayMessage(qsTr("Cannot retrieve video details"));
            }
        }
    }
    request.open("GET", "http://gdata.youtube.com/feeds/api/videos/" + id + "?v=2&alt=json");
    request.send();
}

function getYouTubeVideos(feed) {
    videoListModel.loading = true;

    var doc = new XMLHttpRequest();
    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.DONE) {
            try {
                var results = eval("(" + doc.responseText + ")");
                if (videoListModel.page == 0) {
                    videoListModel.totalResults = parseInt(results.feed.openSearch$totalResults.$t);
                }
                if (feed == _WATCH_LATER_FEED) {
                    var p = playlist;
                    p["playlistId"] = results.feed.yt$playlistId.$t;
                    playlist = p;
                }
                if (results.feed.entry) {
                    var res;
                    for (var i = 0; i < results.feed.entry.length; i++) {
                        res = results.feed.entry[i];
                        if ((res.app$control) && (res.app$control.yt$state) && (res.app$control.yt$state.reasonCode != "limitedSyndication")) {
                            videoListModel.totalResults--;
                        }
                        else {
                            videoListModel.append({ "playerUrl": "http://youtube.com/watch?v=" + res.media$group.yt$videoid.$t, "id": res.id.$t,
                                                      "videoId": res.media$group.yt$videoid.$t, "title": res.title.$t, "name": res.title.$t,
                                                      "description": res.media$group.media$description.$t, "author": res.media$group.media$credit[0].$t,
                                                      "likes": res.yt$rating ? res.yt$rating.numLikes : "0", "dislikes": res.yt$rating ? res.yt$rating.numDislikes : "0",
                                                      "views": res.yt$statistics ? res.yt$statistics.viewCount : "0", "duration": res.media$group.yt$duration.seconds,
                                                      "tags": res.media$group.media$keywords.$t, "uploadDate": res.media$group.yt$uploaded.$t,
                                                      "thumbnail": res.media$group.media$thumbnail[0].url, "comments": res.gd$comments ? res.gd$comments.gd$feedLink.countHint : "0",
                                                      "largeThumbnail": res.media$group.media$thumbnail[1].url, "youtube": true, "isFavourite": feed == _FAVOURITES_FEED });
                        }
                    }
                }
                videoListModel.page++;
                videoListModel.loading = false;
            }
            catch(err) {
                console.log("Cannot retrieve youtube videos");
                videoListModel.loading = false;
                videoListModel.error = true;
            }
        }
    }
    doc.open("GET", feed + "&start-index=" + (videoListModel.page * 30 + 1).toString());
    if (YouTube.userSignedIn) {
        doc.setRequestHeader("Authorization", "AuthSub token=" + YouTube.accessToken);
        doc.setRequestHeader("X-Gdata-Key", "key=" + YouTube.getDeveloperKey());
    }
    doc.send();
}

function getInbox() {
    inboxModel.loading = true;

    var doc = new XMLHttpRequest();
    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.DONE) {
            try {
                var results = eval("(" + doc.responseText + ")");
                if (results.feed.entry) {
                    var res;
                    for (var i = 0; i < results.feed.entry.length; i++) {
                        res = results.feed.entry[i];
                        inboxModel.append({ "playerUrl": "http://youtube.com/watch?v=" + res.media$group.yt$videoid.$t, "id": res.id.$t,
                                              "videoId": res.media$group.yt$videoid.$t, "title": res.title.$t,
                                              "description": res.media$group.media$description.$t, "author": res.author[0].name.$t,
                                              "subject": res.title.$t, "uploader": res.media$group.media$credit[0].$t,
                                              "message": res.summary ? res.summary.$t : "", "messageDate": res.published.$t,
                                              "likes": res.yt$rating ? res.yt$rating.numLikes : "0", "dislikes": res.yt$rating ? res.yt$rating.numDislikes : "0",
                                              "views": res.yt$statistics ? res.yt$statistics.viewCount : "0", "duration": res.media$group.yt$duration.seconds,
                                              "tags": res.media$group.media$keywords.$t, "uploadDate": res.media$group.yt$uploaded.$t,
                                              "thumbnail": res.media$group.media$thumbnail[0].url, "comments": res.gd$comments ? res.gd$comments.gd$feedLink.countHint : "0",
                                              "largeThumbnail": res.media$group.media$thumbnail[1].url, "youtube": true });
                    }
                }
                inboxModel.loading = false;
            }
            catch(err) {
                console.log("Cannot retrieve youtube inbox");
                inboxModel.loading = false;
            }
        }
    }
    doc.open("GET", "http://gdata.youtube.com/feeds/api/users/default/inbox?v=2&max-results=30&alt=json");
    doc.setRequestHeader("Authorization", "AuthSub token=" + YouTube.accessToken);
    doc.send();
}

function getComments(videoId) {
    commentsModel.loading = true;

    var doc = new XMLHttpRequest();
    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.DONE) {
            try {
                var results = eval("(" + doc.responseText + ")");
                if (commentsModel.page == 0) {
                    commentsModel.totalResults = parseInt(results.feed.openSearch$totalResults.$t);
                }
                if (results.feed.entry) {
                    var res;
                    for (var i = 0; i < results.feed.entry.length; i++) {
                        res = results.feed.entry[i];
                        commentsModel.append({ "author": res.author[0].name.$t,
                                                 "date": res.published.$t,
                                                 "comment": res.content.$t,
                                                 "commentId": res.id.$t });
                    }
                }
                commentsModel.page++;
                commentsModel.loading = false;
            }
            catch(err) {
                console.log("Cannot retrieve youtube comments");
                commentsModel.loading = false;
            }
        }
    }
    doc.open("GET", "http://gdata.youtube.com/feeds/api/videos/" + videoId + "/comments?v=2&max-results=30&alt=json&start-index=" + (commentsModel.page * 30 + 1).toString());
    doc.send();
}

function getSubscriptions(feed) {
    subscriptionsModel.loading = true;

    var doc = new XMLHttpRequest();
    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.DONE) {
            try {
                var results = eval("(" + doc.responseText + ")");
                if (subscriptionsModel.page === 0) {
                    subscriptionsModel.totalResults = parseInt(results.feed.openSearch$totalResults.$t);
                }
                if (results.feed.entry) {
                    var res;
                    for (var i = 0; i < results.feed.entry.length; i++) {
                        res = results.feed.entry[i];
                        subscriptionsModel.append({ "title": res.yt$username.$t,
                                                      "subscriptionId": res.id.$t });
                    }
                }
                subscriptionsModel.page++;
                subscriptionsModel.loading = false;
            }
            catch(err) {
                console.log("Cannot retrieve youtube subscriptions");
                subscriptionsModel.error = true;
                subscriptionsModel.loading = false;
            }
        }
    }
    doc.open("GET", feed + "&start-index=" + (subscriptionsModel.page * 30 + 1).toString());
    if (YouTube.userSignedIn) {
        doc.setRequestHeader("Authorization", "AuthSub token=" + YouTube.accessToken);
        doc.setRequestHeader("X-Gdata-Key", "key=" + YouTube.getDeveloperKey());
    }
    doc.send();
}

function getPlaylists(feed) {
    playlistModel.loading = true;

    var doc = new XMLHttpRequest();
    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.DONE) {
            try {
                var results = eval("(" + doc.responseText + ")");
                if (playlistModel.page === 0) {
                    playlistModel.totalResults = parseInt(results.feed.openSearch$totalResults.$t) - 1;
                }
                if (results.feed.entry) {
                    var res;
                    for (var i = 0; i < results.feed.entry.length; i++) {
                        res = results.feed.entry[i];
                        playlistModel.append({ "playlistId": res.yt$playlistId.$t,
                                                 "name": res.title.$t,
                                                 "videoCount": res.yt$countHint.$t,
                                                 "author": res.author[0].name.$t,
                                                 "createdDate": res.published.$t,
                                                 "updatedDate": res.updated.$t,
                                                 "description": res.summary.$t });
                    }
                }
                playlistModel.page++;
                playlistModel.loading = false;
            }
            catch(err) {
                console.log("Cannot retrieve youtube playlists");
                playlistModel.error = true;
                playlistModel.loading = false;
            }
        }
    }
    doc.open("GET", feed + "&start-index=" + (playlistModel.page * 30 + 1).toString());
    if (YouTube.userSignedIn) {
        doc.setRequestHeader("Authorization", "AuthSub token=" + YouTube.accessToken);
        doc.setRequestHeader("X-Gdata-Key", "key=" + YouTube.getDeveloperKey());
    }
    doc.send();
}

function getCurrentUserSubscriptions(feed) {
    youtubeSubscriptionsModel.loading = true;

    var doc = new XMLHttpRequest();
    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.DONE) {
            try {
                var results = eval("(" + doc.responseText + ")");
                if (youtubeSubscriptionsModel.page === 0) {
                    youtubeSubscriptionsModel.totalResults = parseInt(results.feed.openSearch$totalResults.$t);
                }
                if (results.feed.entry) {
                    var res;
                    for (var i = 0; i < results.feed.entry.length; i++) {
                        res = results.feed.entry[i];
                        youtubeSubscriptionsModel.append({ "title": res.yt$username.$t,
                                                      "subscriptionId": res.id.$t });
                    }
                }
                youtubeSubscriptionsModel.page++;
                youtubeSubscriptionsModel.loading = false;
            }
            catch(err) {
                console.log("Cannot retrieve youtube subscriptions");
                youtubeSubscriptionsModel.error = true;
                youtubeSubscriptionsModel.loading = false;
            }
        }
    }
    doc.open("GET", feed + "&start-index=" + (youtubeSubscriptionsModel.page * 30 + 1).toString());
    if (YouTube.userSignedIn) {
        doc.setRequestHeader("Authorization", "AuthSub token=" + YouTube.accessToken);
        doc.setRequestHeader("X-Gdata-Key", "key=" + YouTube.getDeveloperKey());
    }
    doc.send();
}

function getCurrentUserPlaylists(feed) {
    youtubePlaylistModel.loading = true;

    var doc = new XMLHttpRequest();
    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.DONE) {
            try {
                var results = eval("(" + doc.responseText + ")");
                if (youtubePlaylistModel.page === 0) {
                    youtubePlaylistModel.totalResults = parseInt(results.feed.openSearch$totalResults.$t) - 1;
                }
                if (results.feed.entry) {
                    var res;
                    for (var i = 0; i < results.feed.entry.length; i++) {
                        res = results.feed.entry[i];
                        youtubePlaylistModel.append({ "playlistId": res.yt$playlistId.$t,
                                                 "name": res.title.$t,
                                                 "videoCount": res.yt$countHint.$t,
                                                 "author": res.author[0].name.$t,
                                                 "createdDate": res.published.$t,
                                                 "updatedDate": res.updated.$t,
                                                 "description": res.summary.$t });
                    }
                }
                youtubePlaylistModel.page++;
                youtubePlaylistModel.loading = false;
            }
            catch(err) {
                console.log("Cannot retrieve youtube playlists");
                youtubePlaylistModel.error = true;
                youtubePlaylistModel.loading = false;
            }
        }
    }
    doc.open("GET", feed + "&start-index=" + (youtubePlaylistModel.page * 30 + 1).toString());
    if (YouTube.userSignedIn) {
        doc.setRequestHeader("Authorization", "AuthSub token=" + YouTube.accessToken);
        doc.setRequestHeader("X-Gdata-Key", "key=" + YouTube.getDeveloperKey());
    }
    doc.send();
}

function showPlaylistDialog() {
    var playlistDialog = createObject("YTPlaylistDialog.qml", pageStack);
    playlistDialog.playlistChosen.connect(addVideosToPlaylist);
    playlistDialog.open();
}

function addVideosToPlaylist(playlistId) {
    toggleBusy(true);
    var list = [];
    for (var i = 0; i < videoList.checkList.length; i++) {
        list.push(videoListModel.get(videoList.checkList[i]).videoId);
    }
    YouTube.addToPlaylist(list, playlistId);
    videoList.checkList = [];
}

function addVideosToWatchLaterPlaylist() {
    toggleBusy(true);
    var list = [];
    for (var i = 0; i < videoList.checkList.length; i++) {
        list.push(videoListModel.get(videoList.checkList[i]).videoId);
    }
    YouTube.addToWatchLaterPlaylist(list);
    videoList.checkList = [];
}

function addVideosToFavourites() {
    toggleBusy(true);
    var list = [];
    for (var i = 0; i < videoList.checkList.length; i++) {
        list.push(videoListModel.get(videoList.checkList[i]).videoId);
    }
    YouTube.addToFavourites(list);
    videoList.checkList = [];
}

function deleteVideosFromFavourites() {
    toggleBusy(true);
    var list = [];
    for (var i = 0; i < videoList.checkList.length; i++) {
        list.push(videoListModel.get(videoList.checkList[i]).id);
    }
    YouTube.deleteFromFavourites(list);
    videoList.checkList = [];
}

function getUserProfile(user) {
    var doc = new XMLHttpRequest();
    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.DONE) {
            try {
                var res = eval("(" + doc.responseText + ")").entry;
                userThumbnail = res.media$thumbnail.url;
                for (var i = 0; i < res.gd$feedLink.length; i++) {
                    if (res.gd$feedLink[i].rel == "http://gdata.youtube.com/schemas/2007#user.uploads") {
                        videoCount = res.gd$feedLink[i].countHint;
                    }
                }
                for (var ii = 0; ii < res.link.length; ii++) {
                    if (res.link[ii].rel == "related") {
                        website = res.link[ii].href;
                    }
                }
                if (user == "default") {
                    username = res.yt$username.$t;
                    if (YouTube.username === "") {
                        Settings.setYouTubeUsername(username);
                    }
                }
                subscriberCount = res.yt$statistics.subscriberCount;
                about = res.yt$aboutMe ? res.yt$aboutMe.$t : "";
                age = res.yt$age ? res.yt$age.$t : "";
                firstName = res.yt$firstName ? res.yt$firstName.$t : "";
                lastName = res.yt$lastName ? res.yt$lastName.$t : "";
                gender = res.yt$gender ? res.yt$gender.$t : "";
            }
            catch(err) {
                console.log("Cannot retrieve youtube user profile");
            }
        }
    }
    doc.open("GET", "http://gdata.youtube.com/feeds/api/users/" + user + "?v=2&alt=json");
    if (user == "default") {
        doc.setRequestHeader("Authorization", "AuthSub token=" + YouTube.accessToken);
    }
    doc.send();
}

function addVideosToPlaybackQueue() {
    var list = [];
    var video;
    for (var i = 0; i < videoList.checkList.length; i++) {
        video = cloneObject(videoListModel.get(videoList.checkList[i]));
        list.push(video);
    }
    playVideos(list);
    videoList.checkList = [];
}

function addVideosToDownloadQueue(convertToAudio) {
    var list = [];
    var video;
    for (var i = 0; i < videoList.checkList.length; i++) {
        video = cloneObject(videoListModel.get(videoList.checkList[i]));
        list.push(video);
    }
    appendDownloadQueue(list, convertToAudio);
    videoList.checkList = [];
}
