import QtQuick 1.0

Item {
    id: delegate

    signal delegateClicked
    signal delegatePressed

    width: delegate.ListView.view.width
    height: 100

    ListHighlight {
        visible: mouseArea.pressed
    }

    Text {
        id: titleText
        elide: Text.ElideRight
        text: title
        color: _TEXT_COLOR
        font.pixelSize: _STANDARD_FONT_SIZE
        anchors.fill: parent
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: delegateClicked()
        onPressAndHold: delegatePressed()
    }
}
