import QtQuick 1.0
import "scripts/createobject.js" as ObjectCreator

Item {
    id: window

    property bool showMenuButtonOne : true
    property bool showMenuButtonTwo : true
    property bool showMenuButtonThree : true
    property bool showMenuButtonFour : false
    property bool showMenuButtonFive : false

    signal uploads(variant feeds, string title)
    signal favourites(variant feeds, string title)
    signal playlists
    signal subscriptions
    signal dialogClose
    signal goToVideo(variant video)
    signal playVideo(variant video)
    signal goToUserVideos(string username)

    function onMenuButtonOneClicked() {
        /* Show the video upload dialog */

        if (dimmer.state == "") {
            toggleControls(false);
            var uploadDialog = ObjectCreator.createObject("UploadDialog.qml", window);
            uploadDialog.close.connect(closeDialogs);
            dimmer.state = "dim";
            uploadDialog.state = "show";
        }
    }

    function onMenuButtonTwoClicked() {
        /* Show the message inbox dialog */

        if (dimmer.state == "") {
            toggleControls(false);
            var inboxDialog = ObjectCreator.createObject("InboxDialog.qml", window);
            inboxDialog.close.connect(closeDialogs);
            inboxDialog.videoClicked.connect(goToVideo);
            inboxDialog.playClicked.connect(playVideo);
            inboxDialog.userClicked.connect(goToUserVideos);
            dimmer.state = "dim";
            inboxDialog.state = "show";
        }
    }

    function onMenuButtonThreeClicked() {
        /* Raise a dialog enabling the user to choose from available users */

        if (dimmer.state == "") {
            toggleControls(false);
            var userDialog = ObjectCreator.createObject("ChangeUserDialog.qml", window);
            userDialog.close.connect(closeDialogs);
            dimmer.state = "dim";
            userDialog.state = "show";
        }
    }

    function closeDialogs() {
        /* Close any open dialogs and return the window to its default state */

        dialogClose();
        dimmer.state = "";
        toggleControls(true);
    }

    Connections {
        target: YouTube

        onUploadStarted: mouseArea.enabled = false;
    }

    Item {
        id: dimmer

        anchors.fill: window

        Grid {
            id: buttonGrid

            anchors { fill: parent; topMargin: 50; bottomMargin: 60 }
            columns: window.state == "portrait" ? 1 : 2
            rows: window.state == "portrait" ? 4 : 2

            NavButton {
                id: uploadsButton

                width: Math.floor(parent.width / parent.columns)
                height: Math.floor(parent.height / parent.rows)
                smooth: true
                label: qsTr("Uploads")
                icon: (cuteTubeTheme == "light") ? "ui-images/uploadsiconlight.png" : "ui-images/uploadsicon.png"
                onButtonClicked: {
                    var feeds = { "youtube": YouTube.currentUser === "" ? "none" : _UPLOADS_FEED,
                                  "dailymotion": DailyMotion.currentUser === "" ? "none" : _DM_UPLOADS_FEED,
                                  "vimeo": Vimeo.currentUser === "" ? "none" : _VM_UPLOADS_FEED };
                    uploads(feeds, qsTr("My Uploads"));
                }
            }

            NavButton {
                id: favouritesButton

                 width: uploadsButton.width
                 height: uploadsButton.height
                 smooth: true
                 label: qsTr("Favourites")
                 icon: (cuteTubeTheme == "light") ? "ui-images/favouritesiconlight.png" : "ui-images/favouritesicon.png"
                 onButtonClicked: {
                            var feeds = { "youtube": YouTube.currentUser == "" ? "none" : _FAVOURITES_FEED,
                                          "dailymotion": DailyMotion.currentUser == "" ? "none" : _DM_FAVOURITES_FEED,
                                          "vimeo": Vimeo.currentUser == "" ? "none" : _VM_FAVOURITES_FEED };
                            favourites(feeds, qsTr("My Favourites"));
                 }
             }

            NavButton {
                id: playlistsButton

                width: uploadsButton.width
                height: uploadsButton.height
                smooth: true
                label: qsTr("Playlists")
                icon: (cuteTubeTheme == "light") ? "ui-images/playlistsiconlight.png" : "ui-images/playlistsicon.png"
                onButtonClicked: playlists()
            }

            NavButton {
                id: subscriptionsButton

                width: uploadsButton.width
                height: uploadsButton.height
                smooth: true
                label: qsTr("Subscriptions")
                icon: (cuteTubeTheme == "light") ? "ui-images/subscriptionsiconlight.png" : "ui-images/subscriptionsicon.png"
                onButtonClicked: subscriptions()
            }
        }

        states: State {
            name: "dim"
            PropertyChanges { target: dimmer; opacity: 0.1}
        }

        transitions: Transition {
            PropertyAnimation { target: dimmer; properties: "opacity"; duration: 500 }
        }
    }

    states: State {
        name: "portrait"
        when: window.height > window.width
    }
}
