import QtQuick 1.0
import "scripts/createobject.js" as ObjectCreator

Item {
    id: window

    property bool showMenuButtonOne : true
    property bool showMenuButtonTwo : true
    property bool showMenuButtonThree : true
    property bool showMenuButtonFour : false
    property bool showMenuButtonFive : false

    property alias dimmerState : dimmer.state
    property variant categoryFeedOne
    property string categoryFeedOneName
    property alias categoryFeedOneIcon : categoryFeedOneButton.icon
    property variant categoryFeedTwo
    property string categoryFeedTwoName
    property alias categoryFeedTwoIcon : categoryFeedTwoButton.icon

    signal myChannel
    signal liveVideos
    signal loadCategory(variant categoryFeed, string title)
    signal archive
    signal dialogClose

    function showNoAccountDialog() {
        if (dimmer.state == "") {
            toggleControls(false);
            var noAccDialog = ObjectCreator.createObject("NoAccountDialog.qml", window);
            noAccDialog.close.connect(closeDialogs);
            dimmer.state = "dim";
            noAccDialog.state = "show";
        }
    }

    function onMenuButtonOneClicked() {
        /* Show the settings dialog */

        if (dimmer.state == "") {
            toggleControls(false);
            var settingsDialog = ObjectCreator.createObject("SettingsDialog.qml", window);
            settingsDialog.close.connect(closeDialogs);
            dimmer.state = "dim";
            settingsDialog.state = "show";
        }
    }

    function onMenuButtonTwoClicked() {
        /* Show the accounts dialog */

        if (dimmer.state == "") {
            toggleControls(false);
            var accDialog = ObjectCreator.createObject("AccountsDialog.qml", window);
            accDialog.close.connect(closeDialogs);
            dimmer.state = "dim";
            accDialog.state = "show";
        }
    }

    function onMenuButtonThreeClicked() {
        /* Show the 'about' dialog */

        if (dimmer.state == "") {
            toggleControls(false);
            var aboutDialog = ObjectCreator.createObject("AboutDialog.qml", window);
            aboutDialog.close.connect(closeDialogs);
            dimmer.state = "dim";
            aboutDialog.state = "show";
        }
    }

    function onMenuButtonFourClicked() {
        liveVideos();
    }

    function showConfirmExitDialog() {
        /* If a download is taking place, show
          a confirmation dialog */

        toggleControls(false);
        var confirmDialog = ObjectCreator.createObject("ConfirmExitDialog.qml", window);
        confirmDialog.close.connect(closeDialogs);
        dimmer.state = "dim";
        confirmDialog.state = "show";
    }

    function closeDialogs() {
        /* Close any open dialogs and return the window to its default state */

        dialogClose();
        dimmer.state = "";
        toggleControls(true);
    }

    Item {
        id: dimmer

        anchors.fill: window

        Grid {
            id: buttonGrid

            anchors { fill: parent; topMargin: 50; bottomMargin: 60 }
            columns: window.state == "portrait" ? 1 : 2
            rows: window.state == "portrait" ? 4 : 2

            NavButton {
                id: myAccountButton

                width: Math.floor(parent.width / parent.columns)
                height: Math.floor(parent.height / parent.rows)
                smooth: true
                label: qsTr("My Account")
                icon: (cuteTubeTheme == "light") ? "ui-images/myaccounticonlight.png" : "ui-images/myaccounticon.png"
                onButtonClicked: myChannel()
            }

            NavButton {
                id: categoryFeedOneButton

                width: myAccountButton.width
                height: myAccountButton.height
                smooth: true
                label: categoryFeedOneName
                onButtonClicked: loadCategory(categoryFeedOne, categoryFeedOneName)
            }

            NavButton {
                id: categoryFeedTwoButton

                width: myAccountButton.width
                height: myAccountButton.height
                smooth: true
                label: categoryFeedTwoName
                onButtonClicked: loadCategory(categoryFeedTwo, categoryFeedTwoName)
            }

            NavButton {
                id: archiveButton

                width: myAccountButton.width
                height: myAccountButton.height
                smooth: true
                label: qsTr("Archive")
                icon: (cuteTubeTheme == "light") ? "ui-images/downloadiconlight.png" : "ui-images/downloadicon.png"
                onButtonClicked: archive()
            }
        }

        MouseArea {
            id: mouseArea

            anchors.fill: dimmer
            enabled: false
            onClicked: closeDialogs()
        }

        states: State {
            name: "dim"
            PropertyChanges { target: dimmer; opacity: 0.1}
        }

        transitions: Transition {
            PropertyAnimation { target: dimmer; properties: "opacity"; duration: 500 }
        }
    }

    states: State {
        name: "portrait"
        when: window.height > window.width
    }
}
