#include "qmlapplicationviewer.h"
#include "controller.h"
#include "youtube.h"
#include "dailymotion.h"
#include "vimeo.h"
#include "sharing.h"
#include "downloadmanager.h"
#include "folderlistmodel.h"
#include <QtGui/QApplication>
#include <QDeclarativeContext>
#include <QtDeclarative>
#include <QStringList>

//#ifdef Q_WS_MAEMO_5
//#include <QtOpenGL/QGLWidget>
//#endif

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    app.setApplicationName(QString("cuteTube"));
    Controller ct;
    YouTube yt;
    DailyMotion daily;
    Vimeo vimeo;

    QStringList args = app.arguments();
    args.takeFirst();
    if (args.isEmpty()) {

        QmlApplicationViewer viewer;
        viewer.setAttribute(Qt::WA_NoSystemBackground);

        QDeclarativeContext *context = viewer.rootContext();
        ct.setView(&viewer);
        Sharing sh;
        DownloadManager dm;

        QNetworkAccessManager *manager = new QNetworkAccessManager();
        yt.setNetworkAccessManager(manager);
        dm.setNetworkAccessManager(manager);
        sh.setNetworkAccessManager(manager);
        daily.setNetworkAccessManager(manager);
        vimeo.setNetworkAccessManager(manager);

        context->setContextProperty("Controller", &ct);
        context->setContextProperty("DownloadManager", &dm);
        context->setContextProperty("YouTube", &yt);
        context->setContextProperty("Sharing", &sh);
        context->setContextProperty("DailyMotion", &daily);
        context->setContextProperty("Vimeo", &vimeo);

        qmlRegisterType<QDeclarativeFolderListModel>("Models",1,0,"FolderListModel");

#ifdef Q_WS_MAEMO_5
        viewer.addImportPath(QString("/opt/qtm12/imports"));
        viewer.addPluginPath(QString("/opt/qtm12/plugins"));
        viewer.engine()->setOfflineStoragePath("/home/user/.config/cutetube");
        //        viewer.setViewport(new QGLWidget());

        QDir path;
        path.setPath("/home/user/.config/cutetube");
        if (!path.exists()) {
            path.mkpath("/home/user/.config/cutetube");
        }
        path.setPath("/home/user/MyDocs/.cutetube");
        if (!path.exists()) {
            path.mkpath("/home/user/MyDocs/.cutetube");
        }
#endif
        QStringList proxyList = ct.getProxyFromDB();
        QString proxyHost = proxyList.first();
        if (!proxyHost.isEmpty()) {
            int proxyPort = proxyList.last().toInt();
            QNetworkProxy proxy;
            proxy.setType(QNetworkProxy::HttpCachingProxy);
            proxy.setHostName(proxyHost);
            proxy.setPort(proxyPort);
            QNetworkProxy::setApplicationProxy(proxy);
        }

        QString locale = ct.getLanguage();
        QString languagePath;
        languagePath = viewer.engine()->baseUrl().toLocalFile().append("/qml/qmltube/i18n/qml_" + locale);
#ifdef Q_WS_MAEMO_5
        languagePath = "/opt/usr/share/qmltube/qml/qmltube/i18n/qml_" + locale;
#endif
        QTranslator translator;
        if (translator.load(languagePath)) {
            app.installTranslator(&translator);
        }
        viewer.setMainQmlFile(QLatin1String("qml/qmltube/main.qml"));
        viewer.showFullScreen();

        return app.exec();
    }

    else if (args.first() == ("--play")) {
        /* Get the video URL and play the video */

        ct.getMediaPlayerFromDB();
        QObject::connect(&ct, SIGNAL(playbackStarted(QString)), &app, SLOT(quit()));

        QString playerUrl = args.at(1);
        QString videoId;
        if (playerUrl.contains("youtube")) {

            QString quality = "hq";
            if (args.length() > 2) {
                if (args.at(2) == "m") {
                    quality = "mobile";
                }
            }
            videoId = playerUrl.split("v=").at(1).split("&").at(0);
            yt.setPlaybackQuality(quality);
            yt.getVideoUrl(videoId);
            QObject::connect(&yt, SIGNAL(gotVideoUrl(QString)), &ct, SLOT(playVideo(QString)));
            QObject::connect(&yt, SIGNAL(videoUrlError()), &app, SLOT(quit()));
        }
        else if (playerUrl.contains("dailymotion")) {
            videoId = playerUrl.split("/").last();
            daily.getVideoUrl(videoId);
            QObject::connect(&daily, SIGNAL(gotVideoUrl(QString)), &ct, SLOT(playVideo(QString)));
            QObject::connect(&daily, SIGNAL(videoUrlError()), &app, SLOT(quit()));
        }
        else if (playerUrl.contains("vimeo")) {
            videoId = playerUrl.split("/").last();
            vimeo.getVideoUrl(videoId);
            QObject::connect(&vimeo, SIGNAL(gotVideoUrl(QString)), &ct, SLOT(playVideo(QString)));
            QObject::connect(&vimeo, SIGNAL(videoUrlError()), &app, SLOT(quit()));
        }

        return app.exec();
    }
    else {
        qWarning() << "Invalid arguments";
        exit(1);
    }
}
