import Qt 4.7

Item {
    id: dialog

    signal close

    width: parent.width
    anchors { right: parent.left; top: parent.top; bottom: parent.bottom }

    Connections {
        target: dialog.parent

        onDialogClose: {
            dialog.state = "";
            dialog.destroy(600);
        }
    }

    Rectangle {
        id: background

        anchors.fill: dialog
        color: _BACKGROUND_COLOR
        opacity: 0.5
    }

    Image {
        id: icon

        width: 100
        height: 100
        anchors { top: background.top; topMargin: 10; horizontalCenter: background.horizontalCenter }
        smooth: true
        source: "ui-images/cutetubehires.png"
    }

    Text {
        id: title

        anchors { top: icon.bottom; topMargin: 10; horizontalCenter: background.horizontalCenter }
        color: _TEXT_COLOR
        font { pixelSize: _LARGE_FONT_SIZE; bold: true }
        text: qsTr("cuteTube-QML - 0.8.3")
    }

    Text {
        id: description

        anchors { top: title.bottom; left: background.left; right: background.right; margins: 10 }
        color: _TEXT_COLOR
        font.pixelSize: _STANDARD_FONT_SIZE
        wrapMode: TextEdit.WordWrap
        horizontalAlignment: TextEdit.AlignHCenter
        textFormat: Text.RichText
        text: qsTr("A feature-rich YouTube client enabling browsing, playback and download of videos, plus account management. <br><br> &copy; Stuart Howarth 2011")
    }

    CloseButton {
        onButtonClicked: close()
    }

    MouseArea {

        property real xPos

        z: -1
        anchors.fill: dialog
        onPressed: xPos = mouseX
        onReleased: {
            if (xPos - mouseX > 100) {
                close();
            }
        }
    }

    states: State {
        name: "show"
        AnchorChanges { target: dialog; anchors.right: parent.right }
    }

    transitions: Transition {
        AnchorAnimation { easing.type: Easing.OutQuart; duration: 500 }
    }
}
