import Qt 4.7

Item {
    id: dialog

    signal playlistClicked(string playlistId)
    signal close

    width: parent.width
    anchors { right: parent.left; top: parent.top; bottom: parent.bottom }

    Connections {
        target: dialog.parent

        onDialogClose: {
            dialog.state = "";
            dialog.destroy(600);
        }
    }

    Rectangle {
        id: background

        color: _BACKGROUND_COLOR
        radius: 10
        opacity: 0.5
    }

    Text {
        anchors { horizontalCenter: dialog.horizontalCenter; top: dialog.top; topMargin: 10 }
        text: qsTr("Add To Playlist")
        font.pixelSize: _SMALL_FONT_SIZE
        color: _TEXT_COLOR
    }

    ListView {
        id: playlists

        anchors { fill: dialog; topMargin: 50; bottomMargin: 10; leftMargin: 10; rightMargin: 10 }
        clip: true
        focus: true
        snapMode: ListView.SnapToItem
        interactive: visibleArea.heightRatio < 1

        model: playlistModel

        delegate: PlaylistDelegate {
            id: delegate

            onDelegateClicked: {
                var playlistId = playlistModel.get(index).playlistId;
                playlistClicked(playlistId);
            }
        }

        ScrollBar {}
    }

    CloseButton {
        onButtonClicked: close()
    }

    MouseArea {

        property real xPos

        z: -1
        anchors.fill: dialog
        onPressed: xPos = mouseX
        onReleased: {
            if (xPos - mouseX > 100) {
                close();
            }
        }
    }

    states: State {
        name: "show"
        AnchorChanges { target: dialog; anchors.right: parent.right }
    }

    transitions: Transition {
        AnchorAnimation { easing.type: Easing.OutQuart; duration: 500 }
    }
}
