#include "qmlapplicationviewer.h"
#include "controller.h"
#include "youtube.h"
#include "sharing.h"
#include "downloadmanager.h"
#include "folderlistmodel.h"
#include <QtGui/QApplication>
#include <QDeclarativeContext>
#include <QtDeclarative>
#include <QStringList>

//#ifdef Q_WS_MAEMO_5
//#include <QtOpenGL/QGLWidget>
//#endif

static QNetworkCookieJar *jar = new QNetworkCookieJar();

class MyNetworkAccessManagerFactory : public QDeclarativeNetworkAccessManagerFactory
{
public:
    virtual QNetworkAccessManager *create(QObject *parent);
};

QNetworkAccessManager *MyNetworkAccessManagerFactory::create(QObject *parent = 0)
{
    QNetworkAccessManager *nam = new QNetworkAccessManager(parent);

    nam->setCookieJar(jar);
    return nam;
}


int main(int argc, char *argv[])
{
    QApplication app(argc, argv);   
    Controller ct;
    YouTube yt;

    QStringList proxyList = ct.getProxyFromDB();
    QString proxyHost = proxyList.first();
    if (!proxyHost.isEmpty()) {
        int proxyPort = proxyList.last().toInt();
        QNetworkProxy proxy;
        proxy.setType(QNetworkProxy::HttpCachingProxy);
        proxy.setHostName(proxyHost);
        proxy.setPort(proxyPort);
        QNetworkProxy::setApplicationProxy(proxy);
    }

    QStringList args = app.arguments();
    args.takeFirst();
    if (args.isEmpty()) {

        QmlApplicationViewer viewer;
        viewer.setAttribute(Qt::WA_NoSystemBackground);

        QDeclarativeContext *context = viewer.rootContext();
        ct.setView(&viewer);
        Sharing sh;
        DownloadManager dm;

        MyNetworkAccessManagerFactory *factory = new MyNetworkAccessManagerFactory;
        QNetworkAccessManager *manager = factory->create();
        yt.setNetworkAccessManager(manager);
        dm.setNetworkAccessManager(manager);
        sh.setNetworkAccessManager(manager);

        context->setContextProperty("Controller", &ct);
        context->setContextProperty("DownloadManager", &dm);
        context->setContextProperty("YouTube", &yt);
        context->setContextProperty("Sharing", &sh);

        qmlRegisterType<QDeclarativeFolderListModel>("Models",1,0,"FolderListModel");

        viewer.engine()->setNetworkAccessManagerFactory(factory);

#ifdef Q_WS_MAEMO_5
        viewer.engine()->addImportPath(QString("/opt/qtm12/imports"));
        viewer.engine()->addPluginPath(QString("/opt/qtm12/plugins"));
        viewer.engine()->setOfflineStoragePath("/home/user/.config/cutetube");
        QDir path;
        path.setPath("/home/user/.config/cutetube");
        if (!path.exists()) {
            path.mkpath("/home/user/.config/cutetube");
        }
        path.setPath("/home/user/MyDocs/.cutetube");
        if (!path.exists()) {
            path.mkpath("/home/user/MyDocs/.cutetube");
        }
        //        viewer.setViewport(new QGLWidget());

        QString locale = ct.getLanguage();

        QTranslator translator;

        if (translator.load("/opt/usr/share/qmltube/qml/qmltube/i18n/qml_" + locale)) {
            app.installTranslator(&translator);
        }
#endif

        viewer.setMainQmlFile(QLatin1String("qml/qmltube/main.qml"));
        viewer.showFullScreen();

        return app.exec();
    }

    else if (args.first() == ("--play")) {
        /* Get the video URL and play the video */

        QString playerUrl = args.at(1);
        QString quality = "hq";
        if (args.length() > 2) {
            if (args.at(2) == "m") {
                quality = "mobile";
            }
        }
        ct.getMediaPlayerFromDB();
        QObject::connect(&yt, SIGNAL(gotVideoUrl(QString)), &ct, SLOT(playVideo(QString)));
        QObject::connect(&yt, SIGNAL(videoUrlError()), &app, SLOT(quit()));
        QObject::connect(&ct, SIGNAL(playbackStarted(QString)), &app, SLOT(quit()));
        yt.setPlaybackQuality(quality);
        yt.getVideoUrl(playerUrl);

        app.exec();
    }
    else {
        qWarning() << "Invalid arguments";
        exit(1);
    }
}
