import Qt 4.7
import "scripts/settings.js" as Settings
import "scripts/videolistscripts.js" as Scripts

Rectangle {
    id: window

    property string orderColumn : "date"
    property string dateOrder : "ASC"
    property string titleOrder : "DESC"
    property alias checkList: videoList.checkList

    signal playVideos(variant videos)

    function getArchiveVideos(column, ascOrDesc) {
        /* Retrieve archive videos and populate the list model */
        orderColumn = column;

        var videos = Settings.getAllArchiveVideos(column, ascOrDesc);
        for (var i = 0; i < videos.length ; i++) {
            var archiveItem = { "filePath": videos[i][0], "title": videos[i][1],
                "thumbnail": videos[i][2], "quality": videos[i][3],
                "isNew": videos[i][4], "date": videos[i][5] };
            archiveModel.insert(0, archiveItem);
        }
    }

    function onMenuButtonOneClicked() {
        /* Toggle select all/none */

        var cl = videoList.checkList;
        if (cl.length == 0) {
            for (var i = 0; i < videoList.count; i++) {
                cl.push(i);
            }
            videoList.checkList = cl;
        }
        else {
            videoList.checkList = [];
        }
    }

    function onMenuButtonTwoClicked() {
        /* Delete chosen videos from the archive */

        for (var i = 0; i < videoList.checkList.length; i++) {
            var video = archiveModel.get(videoList.checkList[i]);
            if (Settings.deleteVideoFromArchive(video.filePath)) {
                displayMessage(qsTr("Deleted from archive"));
            }
            else {
                displayMessage(qsTr("Unable to delete from archive"))
            }
        }
        videoList.checkList = [];
        archiveModel.clear();
        getArchiveVideos(orderColumn, "ASC");
    }

    function onMenuButtonThreeClicked() {
        /* Delete chosen videos from both the archive and the device */

        for (var i = 0; i < videoList.checkList.length; i++) {
            var video = archiveModel.get(videoList.checkList[i]);
            if (Settings.deleteVideoFromArchive(video.filePath)) {
                Controller.deleteVideo(video.filePath);
            }
            else {
                displayMessage(qsTr("Unable to delete from archive"))
            }
        }
        videoList.checkList = [];
        archiveModel.clear();
        getArchiveVideos(orderColumn, "ASC");
    }

    function onMenuButtonFourClicked() {
        /* Sort the archive list by date */

        archiveModel.clear();
        if (orderColumn == "date") {
            if (dateOrder == "ASC") {
                dateOrder = "DESC";
                getArchiveVideos("date", "DESC");
            }
            else {
                dateOrder = "ASC";
                getArchiveVideos("date", "ASC");
            }
        }
        else {
            getArchiveVideos("date", dateOrder);
        }
    }

    function onMenuButtonFiveClicked() {
        /* Sort the archive list by title */

        archiveModel.clear();
        if (orderColumn == "title") {
            if (titleOrder == "ASC") {
                titleOrder = "DESC";
                getArchiveVideos("title", "DESC");
            }
            else {
                titleOrder = "ASC";
                getArchiveVideos("title", "ASC");
            }
        }
        else {
            getArchiveVideos("title", titleOrder);
        }
    }

    function markItemAsOld(filePath) {
        /* Mark the item with matching filePath as old */

        var i = 0;
        var marked = false
        while ((!marked) && (i < archiveModel.count)) {
            if (archiveModel.get(i).filePath == filePath) {
                archiveModel.setProperty(i, "isNew", 0);
                Settings.editArchiveVideo(filePath, "isNew", 0);
                marked = true;
            }
            i++;
        }
    }

    color: _BACKGROUND_COLOR

    Connections {
        target: Controller

        onAlert: displayMessage(message)
        onPlaybackStarted: markItemAsOld(url)
    }

    Item {
        id: dimmer

        anchors.fill: window

        Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

        Text {
            anchors.centerIn: dimmer
            font.pixelSize: _LARGE_FONT_SIZE
            font.bold: true
            color: "grey"
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            text: "No videos in archive"
            visible: videoList.count == 0
        }

        ListView {
            id: videoList

            property variant checkList : []

            anchors { fill: dimmer; topMargin: 50 }
            snapMode: ListView.SnapToItem
            boundsBehavior: Flickable.DragOverBounds
            highlightMoveDuration: 500
            preferredHighlightBegin: 0
            preferredHighlightEnd: 100
            highlightRangeMode: ListView.StrictlyEnforceRange
            cacheBuffer: 2500
            interactive: visibleArea.heightRatio < 1

            Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

            model: archiveModel

            onCountChanged: positionViewAtIndex(0, ListView.Beginning)

            delegate: ArchiveDelegate {
                id: delegate

                function addOrRemoveFromCheckList() {
                    var cl = videoList.checkList;
                    if (!delegate.checked) {
                        cl.push(index);
                    }
                    else {
                        for (var i = 0; i < cl.length; i++) {
                            if (cl[i] == index) {
                                cl.splice(i, 1);
                            }
                        }
                    }
                    videoList.checkList = cl;
                }

                Connections {
                    onDelegateClicked: Controller.playVideo(archiveModel.get(index).filePath) //playVideos([ archiveModel.get(index) ]);
                    onDelegatePressed: addOrRemoveFromCheckList()
                }

                checked: Scripts.indexInCheckList(index)
            }

            ScrollBar {}
        }

        MouseArea {
            id: mouseArea

            anchors { fill: dimmer; topMargin: 50 }
            enabled: false
        }

        states: State {
            name: "dim"
            PropertyChanges { target: dimmer; opacity: 0.3 }
        }

    }

    states: State {
        name: "portrait"
        when: window.height > window.width
    }
}
