import Qt 4.7

Item {
    id: dialog

    signal playlistClicked(string playlistId)

    width: 600
    height: 300

    Rectangle {
        id: background

        color: backgroundColor
        radius: 10
        opacity: 0.5
        anchors.fill: dialog
        border.width: 2
        border.color: activeColorHigh
    }

    Text {
        anchors { horizontalCenter: dialog.horizontalCenter; top: dialog.top; topMargin: 10 }
        text: qsTr("Add To Playlist")
        font.pixelSize: smallFontSize
        color: textColor
    }

    ListView {
        id: playlists

        anchors { fill: dialog; topMargin: 50; bottomMargin: 10; leftMargin: 10; rightMargin: 10 }
        clip: true
        focus: true
        snapMode: ListView.SnapToItem
        interactive: visibleArea.heightRatio < 1

        model: playlistModel

        delegate: PlaylistDelegate {
            id: delegate

            onDelegateClicked: {
                var playlistId = playlistModel.get(index).playlistId;
                playlistClicked(playlistId);
            }
        }

        ScrollBar {}
    }

    MouseArea {
        z: -1
        anchors.fill: dialog
    }

    states: State {
        name: "portrait"
        PropertyChanges { target: dialog; width: 460; height: 460 }
    }
}
